<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

require_once("Mage.php");
require_once("Varien/Object.php");

require_once("Model/Serializer/Abstract.php");
require_once("Model/Serializer/Groupprices.php");
require_once("Model/Serializer/Groupprices/Loader.php");

/**
 * @covers Crossroads_API_Model_Serializer_Groupprices_Loader
 */
class Crossroads_API_Model_Serializer_Groupprices_LoaderTest extends TestCase {
    /**
     * @dataProvider prepareGroupPricesData
     */
    public function testPrepareGroupPrices($storeId) {
        $priceObj   = new stdClass;
        $groupObj   = new stdClass;
        $idObj      = new stdClass;
        $product    = $this->getMockBuilder(Mage_Catalog_Model_Product::class)
                           ->setMethods(["getId"])
                           ->getMock();
        $groupprice = $this->getMockBuilder(Mage_Catalog_Model_Product::class)
                           ->setMethods(["loadPriceData"])
                           ->getMock();
        $inner      = $this->getMockBuilder(stdClass::class)
                           ->setMethods(["serializeItem"])
                           ->getMock();

        $product->expects($this->once())
                ->method("getId")
                ->will($this->returnValue($idObj));
        $groupprice->expects($this->once())
                   ->method("loadPriceData")
                   ->with($this->identicalTo($idObj), $this->identicalTo($storeId))
                   ->will($this->returnValue($priceObj));
        $inner->expects($this->once())
              ->method("serializeItem")
              ->with($this->identicalTo($priceObj))
              ->will($this->returnValue($groupObj));
        $serializer = new Crossroads_API_Model_Serializer_Groupprices_Loader([
            "inner"   => $inner,
            "storeId" => $storeId,
        ]);

        Mage::_setResourceSingleton("catalog/product_attribute_backend_groupprice", $groupprice);

        $this->assertSame($groupObj, $serializer->serializeItem($product));
    }

    public function prepareGroupPricesData() {
        return [
            [0],
            [4],
        ];
    }
}
