<?php

class Crossroads_API_SearchController extends Crossroads_API_Controller_Super
{
    /**
     * @api {get} /search?query=:query Search products
     * @apiName search
     * @apiGroup Search
     * @apiDescription We'll need to implement our own algorithm here later.
     *
     * @apiParam {String} query Search query
     * @apiParam {Integer} [limit=20] The pagination size, max 100
     * @apiParam {Integer} [page=1] The pagination page
     *
     * @apiSuccess {Object[]} products Array of resulting products
     * @apiSuccess {Integer}  products.id Product id
     * @apiSuccess {String}   products.type Product type
     * @apiSuccess {String}   products.sku
     * @apiSuccess {String}   products.urlKey
     * @apiSuccess {Double}   products.price
     * @apiSuccess {Double}   products.specialPrice
     * @apiSuccess {Double}   products.msrp
     * @apiSuccess {Double}   products.discountPercent
     * @apiSuccess {String}   products.shortDescription
     * @apiSuccess {Mixed}    products.manufacturer String if a manufacturer is set, null otherwise
     * @apiSuccess {String}   products.smallImage
     * @apiSuccess {Boolean}  products.isSalable
     * @apiSuccess {Object[]} products.options  Null if simple product, object if complex, can be turned off in list view through System Configuration
     * @apiSuccess {String}   query   Used search query
     * @apiSuccess {Integer}  totalCount Total number of search hits
     */
    public function indexAction() {
        $searchQuery = $this->getRequest()->getParam("query");
        $store       = Mage::app()->getStore();

        if (!$searchQuery) {
            return $this->sendData([404]);
        }

        $serializer = Mage::getModel("API/factory")->createProductListSerializer($store);
        $model      = Mage::getModel("API/collection_product_fulltext")
            ->setStore($store)
            ->setSearchQuery($searchQuery)
            ->setLimit($this->getRequest()->getQuery("limit"))
            ->setPage($this->getRequest()->getQuery("page"));

        $collection = $model->createCollection();
        $numItems   = $model->getSearchCount();

        return $this->sendData([200, [
            "products"   => $serializer->mapCollection($collection),
            "query"      => $searchQuery,
            "totalCount" => $numItems,
        ]]);
    }
}