<?php

class Crossroads_API_Model_Serializer_Product_Options extends Crossroads_API_Model_Serializer_Abstract {
    const PRODUCT_CONFIGURABLE = "configurable";

    protected $stockInfo  = null;
    protected $attributes = null;
    protected $groupPrices = null;

    public function __construct(array $params = []) {
        $this->attributes    = $params["attributes"];
        $this->customOptions = $params["customOptions"];
        $this->groupPrices   = $params["groupPrices"];
        $this->largeImage    = $params["largeImage"];
        $this->origImage     = $params["origImage"];
        $this->smallImage    = $params["smallImage"];
        $this->stockInfo     = $params["stockInfo"];
    }

    /**
     * Prepares product option-list for a complex product.
     *
     * @param  Mage_Catalog_Model_Product  Configurable product
     * @return array
     */
    public function serializeItem($product) {
        if($product->getTypeId() !== self::PRODUCT_CONFIGURABLE) {
            return null;
        }

        $instance   = $product->getTypeInstance(true);
        $rawOptions = $instance->getConfigurableAttributesAsArray($product);
        $children   = array_filter($instance->getUsedProducts(null, $product), function($p) {
            return $p->isSaleable();
        });

        return array_map(function($option) use($children) {
            return [
                "id"           => (int)$option["attribute_id"],
                "code"         => $option["attribute_code"],
                "title"        => $option["store_label"] ?: $option["frontend_label"] ?: $option["label"],
                "useAsDefault" => $option["use_default"] > 0,
                "position"     => (int)$option["position"],
                "values"       => array_values(array_filter(array_map(function($value) use($children, $option) {
                    // Find the correct child product and output its data
                    foreach($children as $child) {
                        if($child->getData($option["attribute_code"]) !== $value["value_index"]) {
                            continue;
                        }

                        // TODO: Maybe skip this in lists anyway?
                        // FIXME: Test this in actual magento
                        /*if($this->includeGroupPrices) {
                            $attribute = $child->getResource()->getAttribute("group_price");

                            if($attribute) {
                                $attribute->getBackend()->afterLoad($child);
                            }
                            }*/

                        return array_merge([
                            "id"            => (int)$value["value_index"],
                            "sku"           => $child->getSku(),
                            "smallImage"    => $this->smallImage->serializeItem($child),
                            "largeImage"    => $this->largeImage->serializeItem($child),
                            "originalImage" => $this->origImage->serializeItem($child),
                            "label"         => $value["store_label"] ?: $value["label"] ?: $value["default_label"],
                            "isPercent"     => $value["is_percent"] > 0,
                            "isInStock"     => $child->isInStock() > 0,
                            "isSalable"     => $child->getIsSalable() > 0,
                            "groupPrices"   => $this->groupPrices->serializeItem($child->getData("group_price") ?: []),
                            "specialPrice"  => $child->getSpecialPrice() > 0 ? ((double)$child->getSpecialPrice()) : null,
                            "price"         => (double)$child->getFinalPrice(),
                            "originalPrice" => (double)$child->getPrice(),
                            "msrp"          => $child->getMsrp() ? (double)$child->getMsrp() : null,
                            "customOptions" => $this->customOptions->serializeItem($child),
                            "attributes"    => $this->attributes->serializeItem($child),
                        ], $this->stockInfo->serializeItem($child));
                    }

                    // Empty, array_filter above will remove empty entries
                    return null;
                }, $option["values"])))
            ];
        }, $rawOptions);
    }
}
