<?php

class Crossroads_API_Model_Serializer_Product_Customoptions extends Crossroads_API_Model_Serializer_Abstract {
    public function serializeItem($product) {
        if( ! $product->getHasOptions()) {
            return null;
        }

        $options = array_values($product->getProductOptionsCollection()->getItems());

        if(empty($options)) {
            return null;
        }

        return array_map(function($option) {
            return [
                "id"        => (int)$option->getOptionId(),
                "type"      => $option->getType(),
                // NOT A TYPO
                "required"  => (bool)$option->getIsRequire(),
                "maxLength" => (int)$option->getMaxCharacters(),
                "title"     => $option->getStoreTitle() ?: $option->getTitle() ?: $option->getDefaultTitle(),
                "price"     => (double)$option->getPrice(true),
                "values"    => array_map(function($value) {
                    return [
                        "sku"   => $value->getSku(),
                        "title" => $value->getStoreTitle() ?: $value->getTitle() ?: $value->getDefaultTitle(),
                        "price" => (double)$value->getPrice(true),
                    ];
                }, $option->getValues()),
            ];
        }, $options);
    }
}
