<?php

/**
 * Variant of the Image serializer which does not perform any type of image manipulation,
 * instead a link to the original file is returned.
 */
class Crossroads_API_Model_Serializer_Image_Original extends Crossroads_API_Model_Serializer_Abstract {
    protected $attr = "image";

    public function __construct(array $params = []) {
        array_key_exists("attr", $params) && $this->attr = $params["attr"];
    }

    /**
     * @param  Mage_Catalog_Model_product
     * @return string
     */
    public function serializeItem($item) {
        return (string)Mage::helper("catalog/image")
            ->init($item, $this->attr);
    }
}
