<?php

class Crossroads_API_Model_Serializer_Image_Mediagallery extends Crossroads_API_Model_Serializer_Abstract {
    protected $largeFill = false;
    protected $largeSize = 400;
    protected $smallFill = false;
    protected $smallSize = 400;
    protected $thumbFill = false;
    protected $thumbSize = 400;

    public function __construct(array $params = []) {
        array_key_exists("largeFill", $params) && $this->largeFill = $params["largeFill"];
        array_key_exists("largeSize", $params) && $this->largeSize = $params["largeSize"];
        array_key_exists("smallFill", $params) && $this->smallFill = $params["smallFill"];
        array_key_exists("smallSize", $params) && $this->smallSize = $params["smallSize"];
        array_key_exists("thumbFill", $params) && $this->thumbFill = $params["thumbFill"];
        array_key_exists("thumbSize", $params) && $this->thumbSize = $params["thumbSize"];
    }

    public function serializeItem($item) {
        $coll = $item->getMediaGalleryImages();

        if( ! $coll) {
            return [];
        }

        return array_values(array_map(function($image) use($item) {
            // TODO: Make this composable
            return [
                "thumbnail" => (string)Mage::helper("catalog/image")
                    ->init($item, "image", $image->getFile())
                    ->keepFrame($this->thumbFill)
                    ->resize($this->thumbSize),
                "original"  => Mage::getModel("catalog/product_media_config")
                    ->getMediaUrl($image->getFile()),
                "large"     => (string)Mage::helper("catalog/image")
                    ->init($item, "image", $image->getFile())
                    ->keepFrame($this->largeFill)
                    ->resize($this->largeSize),
                "image"     => (string)Mage::helper("catalog/image")
                    ->init($item, "image", $image->getFile())
                    ->keepFrame($this->smallFill)
                    ->resize($this->smallSize),
            ];
        }, $coll->getItems()));
    }
}
