<?php

/**
 * Wrapper for the Groupprice serializer, loading the data from the product attribute backend.
 */
class Crossroads_API_Model_Serializer_Groupprices_Loader extends Crossroads_API_Model_Serializer_Abstract {
    protected $wrapped = null;
    protected $storeId = 0;

    public function __construct(array $props = []) {
        $this->wrapped = $props["inner"];
        $this->storeId = $props["storeId"];
    }

    /**
     * @param  Mage_Catalog_Model_Product
     * @return Array<["groupCode" => string|null, "price" => double]>
     */
    public function serializeItem($item) {
        return $this->wrapped->serializeItem(
            Mage::getResourceSingleton("catalog/product_attribute_backend_groupprice")
                ->loadPriceData($item->getId(), $this->storeId));
    }
}
