<?php

class Crossroads_API_Model_Collection_Product extends Crossroads_API_Model_Collection_Abstract {
    protected $visibility = ["neq" => Mage_Catalog_Model_Product_Visibility::VISIBILITY_NOT_VISIBLE];
    protected $storeId    = null;

    public function setStore($store) {
        $this->storeId = $store->getId();

        return $this;
    }

    /**
     * Sets the visibility required on products, default is everything which is not NOT_VISBLE.
     *
     * @param  string  Constant from Mage_Catalog_Model_Product_Visibility
     * @param  boolean If to also include VISIBILITY_BOTH
     * @return self
     */
    public function setVisibility($visibility, $both = false) {
        if($both) {
            $this->visibility = ["in" => [$visibility, Mage_Catalog_Model_Product_Visibility::VISIBILITY_BOTH]];
        }
        else {
            $this->visibility = ["eq" => $visibility];
        }

        return $this;
    }

    public function prepare($collection) {
        $storeId = $this->storeId === null ? Mage::app()->getStore()->getStoreId() : $this->storeId;

        return parent::prepare($collection->addAttributeToSelect("*")
                   ->addAttributeToFilter("visibility", $this->visibility)
                   ->addStoreFilter($storeId)
                   ->addMinimalPrice());
    }

    protected function newCollection() {
        return Mage::getModel("catalog/product")->getCollection();
    }
}
