<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

require_once("Mage.php");

require_once("Model/Serializer/Abstract.php");
require_once("Model/Serializer/Product/Customoptions.php");

/**
 * @covers Crossroads_API_Model_Serializer_Product_Customoptions
 */
class Crossroads_API_Model_Serializer_Product_CustomoptionsTest extends TestCase {
    /**
     * @dataProvider serializeCustomOptionsAttributes
     */
    public function testSerializeCustomOptions($hasOptions, $options, $expected) {
        $opts       = $this->getMockBuilder(stdClass::class)
                           ->setMethods(["getItems"])
                           ->getMock();
        $product    = $this->getMockBuilder(Mage_Catalog_Model_Product::class)
                           ->setMethods(["getHasOptions", "getProductOptionsCollection"])
                           ->getMock();
        $serializer = new Crossroads_API_Model_Serializer_Product_Customoptions();

        $opts->expects($this->any())
             ->method("getItems")
             ->will($this->returnValue($options));
        $product->expects($this->once())
                ->method("getHasOptions")
                ->will($this->returnValue($hasOptions));
        $product->expects($this->any())
                ->method("getProductOptionsCollection")
                ->will($this->returnValue($opts));

        $this->assertSame($expected, $serializer->serializeItem($product));
    }

    public function serializeCustomOptionsAttributes() {
        $mkOption = function($methods, $price) {
            $opt = $this->getMockBuilder(stdClass::class)
                        ->setMethods(["getOptionId", "getType", "getIsRequire", "getMaxCharacters", "getStoreTitle", "getTitle", "getDefaultTitle", "getPrice", "getValues"])
                        ->getMock();

            foreach($methods as $method => $value) {
                $opt->expects($this->any())
                    ->method($method)
                    ->will($this->returnValue($value));
            }

            $opt->expects($this->any())
                ->method("getPrice")
                ->with($this->equalTo(true))
                ->will($this->returnValue($price));

            return $opt;
        };

        $mkValue = function($methods, $price) {
            $opt = $this->getMockBuilder(stdClass::class)
                        ->setMethods(["getSku", "getStoreTitle", "getTitle", "getDefaultTitle", "getPrice"])
                        ->getMock();

            foreach($methods as $method => $value) {
                $opt->expects($this->any())
                    ->method($method)
                    ->will($this->returnValue($value));
            }

            $opt->expects($this->any())
                ->method("getPrice")
                ->with($this->equalTo(true))
                ->will($this->returnValue($price));

            return $opt;
        };

        return [
            [false, [], null],
            [true, [], null],
            [true, [$mkOption(["getValues" => []], null)], [["id" => 0, "type" => null, "required" => false, "maxLength" => 0, "title" => null, "price" => 0.0, "values" => []]]],
            [true, [$mkOption(["getOptionId" => 4, "getType" => "foobar", "getIsRequire" => true, "getMaxCharacters" => "5", "getDefaultTitle" => "The Default", "getValues" => []], "123")], [["id" => 4, "type" => "foobar", "required" => true, "maxLength" => 5, "title" => "The Default", "price" => 123.0, "values" => []]]],
            [true, [$mkOption(["getOptionId" => 4, "getType" => "foobar", "getIsRequire" => false, "getMaxCharacters" => "5", "getTitle" => "The Title", "getDefaultTitle" => "The Default", "getValues" => []], "123")], [["id" => 4, "type" => "foobar", "required" => false, "maxLength" => 5, "title" => "The Title", "price" => 123.0, "values" => []]]],
            [true, [$mkOption(["getOptionId" => 4, "getType" => "foobar", "getIsRequire" => false, "getMaxCharacters" => "5", "getStoreTitle" => "Store Title", "getTitle" => "The Title", "getDefaultTitle" => "The Default", "getValues" => []], "123")], [["id" => 4, "type" => "foobar", "required" => false, "maxLength" => 5, "title" => "Store Title", "price" => 123.0, "values" => []]]],
            [false, [$mkOption(["getOptionId" => 4, "getType" => "foobar", "getIsRequire" => true, "getMaxCharacters" => "5", "getDefaultTitle" => "The Default", "getValues" => []], "123")], null],
            [true, [$mkOption(["getOptionId" => 11, "getType" => "text", "getIsRequire" => false, "getStoreTitle" => "Empty", "getValues" => []], 3), $mkOption([
                "getOptionId" => 4, "getType" => "foobar", "getIsRequire" => true, "getMaxCharacters" => "5", "getDefaultTitle" => "The Default", "getValues" => [
                    $mkValue(["getSku" => "abc", "getDefaultTitle" => "Default"], 32),
                    $mkValue(["getSku" => "bbb", "getTitle" => "title", "getDefaultTitle" => "Default"], 23),
                    $mkValue(["getSku" => "c", "getStoreTitle" => "Store", "getTitle" => "title", "getDefaultTitle" => "Default"], 3),
                ],
            ], "123")], [
                [ "id" => 11, "type" => "text", "required" => false, "maxLength" => 0, "title" => "Empty", "price" => 3.0, "values" => [] ],
                [
                    "id" => 4, "type" => "foobar", "required" => true, "maxLength" => 5, "title" => "The Default", "price" => 123.0, "values" => [ [ "sku" => "abc", "title" => "Default", "price" => 32.0 ], [ "sku" => "bbb", "title" => "title", "price" => 23.0 ], [ "sku" => "c", "title" => "Store", "price" => 3.0 ] ]
                ],
            ]],
        ];
    }
}
