<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

require_once("Mage.php");

require_once("Mage/Core/Model/Abstract.php");
require_once("Model/Factory.php");
require_once("Model/Serializer/Abstract.php");
require_once("Model/Serializer/Groupprices.php");
require_once("Model/Serializer/Groupprices/Loader.php");
require_once("Model/Serializer/Product/Stockinfo.php");

/**
 * @covers Crossroads_API_Model_Factory
 */
class Crossroads_API_Model_FactoryTest extends TestCase {
    public function setUp() {
        Mage::_clear();
    }

    public function testCreateProductListSerializer() {
        Mage::_initConfig([ "store" => [ ] ]);

        $null      = new stdClass;
        $stockInfo = new stdClass;
        $attrs     = new stdClass;
        $ser       = new stdClass;
        $image     = new stdClass;
        $attrsCtor = $this->createPartialMock(stdClass::class, ["__invoke"]);
        $listCtor  = $this->createPartialMock(stdClass::class, ["__invoke"]);
        $nullCtor  = $this->createPartialMock(stdClass::class, ["__invoke"]);

        $attrsCtor->expects($this->once())
                  ->method("__invoke")
                  ->with($this->equalTo([]))
                  ->will($this->returnValue($attrs));
        $listCtor->expects($this->once())
                 ->method("__invoke")
                 ->with($this->identicalTo([
                    "attributes"  => $attrs,
                    "groupPrices" => $null,
                    "options"     => $null,
                    "smallImage"  => $image,
                    "stockInfo"   => $stockInfo,
                    "thumbnail"   => $null,
                 ]))
                 ->will($this->returnValue($ser));
        $nullCtor->expects($this->any())
                 ->method("__invoke")
                 ->with($this->identicalTo([ "value" => null ]))
                 ->will($this->returnValue($null));

        Mage::_setModel("API/serializer_constant", $nullCtor);
        Mage::_setModel("API/serializer_attributes", $attrsCtor);
        Mage::_setModel("API/serializer_product_stockinfo_empty", $stockInfo);
        Mage::_setModel("API/serializer_product_list", $listCtor);

        $model = $this->getMockBuilder(Crossroads_API_Model_Factory::class)
                      ->setMethods(["createSmallImageSerializer"])
                      ->getMock();
        $model->expects($this->once())
              ->method("createSmallImageSerializer")
              ->with($this->identicalTo(Mage::app()->getStore()))
              ->will($this->returnValue($image));

        $this->assertSame($model->createProductListSerializer(Mage::app()->getStore()), $ser);
    }

    public function testCreateProductListSerializer2() {
        Mage::_initConfig([ "store" => [ "id" => 1234, "websiteId" => 4321, "config" => [
            Crossroads_API_Model_Factory::CONFIG_LIST_ATTRIBUTES   => serialize([ "_some_list_attrs" ]),
            Crossroads_API_Model_Factory::CONFIG_LIST_THUMBNAIL    => "1",
            Crossroads_API_Model_Factory::CONFIG_LIST_GROUP_PRICES => true,
            Crossroads_API_Model_Factory::CONFIG_LIST_STOCK_QTY    => true,
            Crossroads_API_Model_Factory::CONFIG_LIST_OPTIONS      => true,
        ] ] ]);

        $null       = new stdClass;
        $stockInfo  = $this->createMock(Crossroads_API_Model_Serializer_Product_Stockinfo::class);
        $attrs      = new stdClass;
        $ser        = new stdClass;
        $group      = new stdClass;
        $loader     = $this->createMock(Crossroads_API_Model_Serializer_Groupprices_Loader::class);
        $image      = new stdClass;
        $thumb      = new stdClass;
        $option     = new stdClass;
        $attrsCtor  = $this->createPartialMock(stdClass::class, ["__invoke"]);
        $listCtor   = $this->createPartialMock(stdClass::class, ["__invoke"]);
        $loaderCtor = $this->createPartialMock(stdClass::class, ["__invoke"]);

        $attrsCtor->expects($this->once())
                  ->method("__invoke")
                  ->with($this->equalTo([ "_some_list_attrs" ]))
                  ->will($this->returnValue($attrs));
        $loaderCtor->expects($this->once())
                   ->method("__invoke")
                   ->with($this->identicalTo([
                       "websiteId" => 4321,
                       "storeId"   => 1234,
                   ]))
                   ->will($this->returnValue($loader));
        $listCtor->expects($this->once())
                 ->method("__invoke")
                 ->with($this->identicalTo([
                    "attributes"  => $attrs,
                    "groupPrices" => $loader,
                    "options"     => $option,
                    "smallImage"  => $image,
                    "stockInfo"   => $stockInfo,
                    "thumbnail"   => $thumb,
                 ]))
                 ->will($this->returnValue($ser));

        Mage::_setModel("API/serializer_attributes", $attrsCtor);
        Mage::_setModel("API/serializer_product_list", $listCtor);
        Mage::_setModel("API/serializer_groupprices_loader", $loaderCtor);
        Mage::_setModel("API/serializer_product_stockinfo", $stockInfo);

        $model = $this->getMockBuilder(Crossroads_API_Model_Factory::class)
                      ->setMethods([
                          "createThumbImageSerializer",
                          "createSmallImageSerializer",
                          "createProductOptionSerializer",
                      ])
                      ->getMock();
        $model->expects($this->once())
              ->method("createThumbImageSerializer")
              ->with($this->identicalTo(Mage::app()->getStore()))
              ->will($this->returnValue($thumb));
        $model->expects($this->once())
              ->method("createSmallImageSerializer")
              ->with($this->identicalTo(Mage::app()->getStore()))
              ->will($this->returnValue($image));
        $model->expects($this->once())
              ->method("createProductOptionSerializer")
              ->with($this->identicalTo(Mage::app()->getStore(), $group, $stockInfo))
              ->will($this->returnValue($option));

        $this->assertSame($model->createProductListSerializer(Mage::app()->getStore()), $ser);
    }

    public function testCreateProductOptionSerializer() {
        Mage::_initConfig([ "store" => [ "id" => 1234, "websiteId" => 4321, "config" => [
            Crossroads_API_Model_Factory::CONFIG_OPTION_ATTRIBUTES => serialize([ "_some_option_attrs" ]),
        ] ] ]);

        $large      = new stdClass;
        $small      = new stdClass;
        $orig       = new stdClass;
        $attrs      = new stdClass;
        $ser        = new stdClass;
        $custom     = new stdClass;
        $stock      = $this->createMock(Crossroads_API_Model_Serializer_Product_Stockinfo::class);
        $group      = $this->createMock(Crossroads_API_Model_Serializer_Groupprices::class);
        $attrsCtor  = $this->createPartialMock(stdClass::class, ["__invoke"]);
        $optionCtor = $this->createPartialMock(stdClass::class, ["__invoke"]);

        $attrsCtor->expects($this->once())
                  ->method("__invoke")
                  ->with($this->equalTo([ "_some_option_attrs" ]))
                  ->will($this->returnValue($attrs));
        $optionCtor->expects($this->once())
                 ->method("__invoke")
                 ->with($this->identicalTo([
                    "attributes"  => $attrs,
                    "customOptions" => $custom,
                    "groupPrices" => $group,
                    "largeImage"  => $large,
                    "origImage"   => $orig,
                    "smallImage"  => $small,
                    "stockInfo"   => $stock,
                 ]))
                 ->will($this->returnValue($ser));
        $model = $this->getMockBuilder(Crossroads_API_Model_Factory::class)
                      ->setMethods([
                          "createLargeImageSerializer",
                          "createSmallImageSerializer",
                          "createOrigImageSerializer",
                      ])
                      ->getMock();

        $model->expects($this->once())
              ->method("createLargeImageSerializer")
              ->with($this->identicalTo(Mage::app()->getStore()))
              ->will($this->returnValue($large));
        $model->expects($this->once())
              ->method("createSmallImageSerializer")
              ->with($this->identicalTo(Mage::app()->getStore()))
              ->will($this->returnValue($small));
        $model->expects($this->once())
              ->method("createOrigImageSerializer")
              ->with($this->identicalTo(Mage::app()->getStore()))
              ->will($this->returnValue($orig));

        Mage::_setModel("API/serializer_attributes", $attrsCtor);
        Mage::_setModel("API/serializer_product_customoptions", $custom);
        Mage::_setModel("API/serializer_product_options", $optionCtor);

        $reflection = new ReflectionObject($model);
        $method     = $reflection->getMethod("createProductOptionSerializer");

        $method->setAccessible(true);

        $this->assertSame($method->invoke($model, Mage::app()->getStore(), $group, $stock), $ser);
    }

    public function testCreateOrigImageSerializer() {
        Mage::_initConfig([ "store" => [ ] ]);

        $ser     = new stdClass;
        $serCtor = $this->createPartialMock(stdClass::class, ["__invoke"]);

        $serCtor->expects($this->once())
                ->method("__invoke")
                ->with($this->identicalTo([ "attr" => "image" ]))
                ->will($this->returnValue($ser));

        Mage::_setModel("API/serializer_image_original", $serCtor);

        $model      = new Crossroads_API_Model_Factory();
        $reflection = new ReflectionObject($model);
        $method     = $reflection->getMethod("createOrigImageSerializer");

        $method->setAccessible(true);

        $this->assertSame($method->invoke($model, Mage::app()->getStore()), $ser);
    }

    public function testCreateThumbImageSerializer() {
        Mage::_initConfig([ "store" => [ "config" => [
            Crossroads_API_Model_Factory::CONFIG_IMAGE_THUMB_SIZE => "134",
            Crossroads_API_Model_Factory::CONFIG_IMAGE_THUMB_FILL => "0",
        ] ] ]);

        $ser     = new stdClass;
        $serCtor = $this->createPartialMock(stdClass::class, ["__invoke"]);

        $serCtor->expects($this->once())
                ->method("__invoke")
                ->with($this->identicalTo([
                    "attr" => "thumbnail",
                    "size" => "134",
                    "fill" => "0",
                ]))
                ->will($this->returnValue($ser));

        Mage::_setModel("API/serializer_image", $serCtor);

        $model      = new Crossroads_API_Model_Factory();
        $reflection = new ReflectionObject($model);
        $method     = $reflection->getMethod("createThumbImageSerializer");

        $method->setAccessible(true);

        $this->assertSame($method->invoke($model, Mage::app()->getStore()), $ser);
    }

    public function testCreateSmallImageSerializer() {
        Mage::_initConfig([ "store" => [ "config" => [
            Crossroads_API_Model_Factory::CONFIG_IMAGE_SMALL_SIZE => "145",
            Crossroads_API_Model_Factory::CONFIG_IMAGE_SMALL_FILL => "23",
        ] ] ]);

        $ser     = new stdClass;
        $serCtor = $this->createPartialMock(stdClass::class, ["__invoke"]);

        $serCtor->expects($this->once())
                ->method("__invoke")
                ->with($this->identicalTo([
                    "attr" => "small_image",
                    "size" => "145",
                    "fill" => "23",
                ]))
                ->will($this->returnValue($ser));

        Mage::_setModel("API/serializer_image", $serCtor);

        $model      = new Crossroads_API_Model_Factory();
        $reflection = new ReflectionObject($model);
        $method     = $reflection->getMethod("createSmallImageSerializer");

        $method->setAccessible(true);

        $this->assertSame($method->invoke($model, Mage::app()->getStore()), $ser);
    }

    public function testCreateLargeImageSerializer() {
        Mage::_initConfig([ "store" => [ "config" => [
            Crossroads_API_Model_Factory::CONFIG_IMAGE_LARGE_SIZE => "156",
            Crossroads_API_Model_Factory::CONFIG_IMAGE_LARGE_FILL => "1",
        ] ] ]);

        $ser     = new stdClass;
        $serCtor = $this->createPartialMock(stdClass::class, ["__invoke"]);

        $serCtor->expects($this->once())
                ->method("__invoke")
                ->with($this->identicalTo([
                    "attr" => "image",
                    "size" => "156",
                    "fill" => "1",
                ]))
                ->will($this->returnValue($ser));

        Mage::_setModel("API/serializer_image", $serCtor);

        $model      = new Crossroads_API_Model_Factory();
        $reflection = new ReflectionObject($model);
        $method     = $reflection->getMethod("createLargeImageSerializer");

        $method->setAccessible(true);

        $this->assertSame($method->invoke($model, Mage::app()->getStore()), $ser);
    }
}
