<?php

$installer = $this;
/* @var $installer Mage_Customer_Model_Entity_Setup */

$installer->startSetup();

$installer->addAttribute('customer', 'api_default_shipping_method', [
    "group"                => "Default",
    "type"                 => "varchar",
    "label"                => "Default Shipping Method",
    "input"                => "select",
    "source"               => "API/eav_entity_attribute_source_shippingmethod",
    "global"               => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
    "required"             => 0,
    "default"              => null,
    "visible_on_front"     => 1,
    "used_for_price_rules" => 0,
    "adminhtml_only"       => 0,
    "position"             => 117,
]);

// We need to manually add the attribute here to be able to see it in admin
$attribute = Mage::getSingleton("eav/config")->getAttribute("customer", "api_default_shipping_method");

$attribute->setData("used_in_forms", ["adminhtml_customer"]);
$attribute->save();

$installer->endSetup();
