<?php

/**
 * Serializes the bundle products of a given product.
 *
 * Params:
 *  * attributes:  Crossroads_API_Model_Serializer_Attributes
 *  * groupPrices: Crossroads_API_Model_Serializer_Groupprices
 *  * largeImage:  Crossroads_API_Model_Serializer_Image
 *  * origImage:   Crossroads_API_Model_Serializer_Image_Original
 *  * smallImage:  Crossroads_API_Model_Serializer_Image
 *  * stockInfo:   Crossroads_API_Model_Serializer_Product_Stockinfo
 */
class Crossroads_API_Model_Serializer_Product_Bundle extends Crossroads_API_Model_Serializer_Abstract {
    const PRODUCT_BUNDLE = "bundle";

    protected $stockInfo   = null;
    protected $largeImage  = null;
    protected $origImage   = null;
    protected $smallImage  = null;
    protected $groupPrices = null;

    public function __construct(array $params = []) {
        $this->attributes    = $params["attributes"];
        $this->groupPrices   = $params["groupPrices"];
        $this->largeImage    = $params["largeImage"];
        $this->origImage     = $params["origImage"];
        $this->smallImage    = $params["smallImage"];
        $this->stockInfo     = $params["stockInfo"];

        parent::__construct($params);
    }

    /**
     * Prepares product option-list for a complex product.
     *
     * @param  Mage_Catalog_Model_Product  Configurable product
     * @return array
     */
    public function serializeItem($product) {
        if($product->getTypeId() !== self::PRODUCT_BUNDLE) {
            return null;
        }

        $instance = $product->getTypeInstance();

        return array_values(array_map(function($option) use($product) {
            return [
                "id"       => (int)$option->getOptionId(),
                "required" => (boolean)$option->getRequired(),
                "position" => (int)$option->getPosition(),
                "type"     => $option->getType(),
                "title"    => $option->getTitle() ?: $option->getDefaultTitle(),
                "options"  => array_map(function($selection) use($product) {
                    $price = 0.0;

                    switch($selection->getSelectionPriceType()) {
                    case 0: // Fixed
                        $price = $selection->getSelectionPriceValue();
                        break;
                    case 1: // Percent
                        $price = $product->getFinalPrice() * ($selection->getSelectionPriceValue() / 100);
                        break;
                    }

                    return array_merge([
                        "id"               => (int)$selection->getSelectionId(),
                        "isDefault"        => (bool)$selection->getIsDefault(),
                        "qty"              => (int)$selection->getSelectionQty(),
                        "isQtyFixed"       => !$selection->getSelectionCanChangeQty(),
                        "name"             => $selection->getName(),
                        "shortDescription" => $selection->getShortDescription(),
                        "smallImage"       => $this->smallImage->serializeItem($selection),
                        "largeImage"       => $this->largeImage->serializeItem($selection),
                        "originalImage"    => $this->origImage->serializeItem($selection),
                        "isInStock"        => $selection->isInStock() > 0,
                        "isSalable"        => $selection->getIsSalable() > 0,
                        "groupPrices"      => $this->groupPrices->serializeItem($selection),
                        "price"            => (double)$price,
                        "msrp"             => $selection->getMsrp() ? (double)$selection->getMsrp() : null,
                        "attributes"       => $this->attributes->serializeItem($selection),
                    ], $this->stockInfo->serializeItem($selection));
                }, $option->getSelections() ?: []),
            ];
        }, $instance->getOptions()));
    }
}
