<?php

/**
 * Reads an image from an entity according to configuration and produces a link to a resized file.
 */
class Crossroads_API_Model_Serializer_Image extends Crossroads_API_Model_Serializer_Abstract {
    protected $fill = false;
    protected $size = 400;
    protected $attr = "image";

    public function __construct(array $params = []) {
        array_key_exists("attr", $params) && $this->attr = $params["attr"];
        array_key_exists("size", $params) && $this->size = $params["size"];
        array_key_exists("fill", $params) && $this->fill = $params["fill"];

        parent::__construct($params);
    }

    /**
     * @param  Mage_Catalog_Model_product
     * @return string
     */
    public function serializeItem($item) {
        return (string)Mage::helper("catalog/image")
            ->init($item, $this->attr)
            ->keepFrame($this->fill)
            ->resize($this->size);
    }
}
