<?php

/**
 * Factory object allowing decoration of models.
 *
 * Example:
 *
 * ```
 * // Module code
 * $model = Crossroads_API_Model_Factory_Serializer::create("module/model", [
 *     "param" => "someValue",
 * ]);
 *
 * // Other module observer
 * public function moduleModel($event) {
 *     $event->getSerializer()->decorate(Mage::getModel("other/decorator"));
 * }
 * ```
 */
class Crossroads_API_Model_Factory_Serializer {
    protected $serializer = null;

    public function __construct($serializer) {
        $this->serializer = $serializer;
    }

    public function getSerializer() {
        return $serializer;
    }

    public function decorate(Crossroads_API_Model_Serializer_Decorator $decorator) {
        $this->serializer = $decorator->setInner($this->serializer);

        return $this;
    }

    public static function create($model, array $params = []) {
        // TODO: Prefix name
        $name       = strtr($model, "/", "_");
        $serializer = new static(Mage::getModel($model, $params));

        Mage::dispatchEvent($name, [
            "serializer" => $serializer,
        ]);

        return $serializer->getSerializer();
    }
}
