<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

require_once("Mage.php");
require_once("Mage/Catalog/Model/Product.php");

require_once("Model/Serializer/Abstract.php");
require_once("Model/Serializer/Product/Abstract.php");
require_once("Model/Serializer/Product/Stockinfo.php");

/**
 * @covers Crossroads_API_Model_Serializer_Product_Stockinfo
 */
class Crossroads_API_Model_Serializer_Product_StockinfoTest extends TestCase {
    public function setUp() {
        Mage::_clear();
    }

    /**
     * @dataProvider getStockInfoData
     */
    public function testGetStockInfo($backorders, $manageStock, $qty, $expected) {
        Mage::_initConfig([ "store" => [] ]);

        $product   = $this->getMockBuilder(Mage_Catalog_Model_Product::class)
                          ->setMethods([])
                          ->getMock();
        $stockItem = $this->getMockBuilder(Mage_Catalog_Model_Product::class)
                          ->setMethods(["loadByProduct", "getBackorders", "getManageStock", "getQty"])
                          ->getMock();

        $stockItem->expects($this->once())
                  ->method("loadByProduct")
                  ->with($this->identicalTo($product))
                  ->will($this->returnSelf());
        $stockItem->expects($this->once())
                  ->method("getBackorders")
                  ->will($this->returnValue($backorders));
        $stockItem->expects($this->once())
                  ->method("getManageStock")
                  ->will($this->returnValue($manageStock));
        $stockItem->expects($this->any())
                  ->method("getQty")
                  ->will($this->returnValue($qty));

        Mage::_setModel("cataloginventory/stock_item", $stockItem);

        $serializer = new Crossroads_API_Model_Serializer_Product_Stockinfo();

        $this->assertSame($expected, $serializer->serializeItem($product));
    }

    public function getStockInfoData() {
        return [
            [
                null,
                null,
                null,
                [ "stockQty" => null, "stockBackorders" => false, "stockManage" => false]
            ],
            [
                null,
                "1",
                null,
                [ "stockQty" => 0.0, "stockBackorders" => false, "stockManage" => true]
            ],
            [
                null,
                true,
                null,
                [ "stockQty" => 0.0, "stockBackorders" => false, "stockManage" => true]
            ],
            [
                "1",
                true,
                null,
                [ "stockQty" => 0.0, "stockBackorders" => true, "stockManage" => true]
            ],
            [
                true,
                true,
                null,
                [ "stockQty" => 0.0, "stockBackorders" => true, "stockManage" => true]
            ],
            [
                true,
                true,
                12,
                [ "stockQty" => 12.0, "stockBackorders" => true, "stockManage" => true]
            ],
            [
                false,
                true,
                12.6,
                [ "stockQty" => 12.6, "stockBackorders" => false, "stockManage" => true]
            ],
            [
                false,
                false,
                12.6,
                [ "stockQty" => null, "stockBackorders" => false, "stockManage" => false]
            ],
        ];
    }
}
