<?php

class Crossroads_API_Model_Serializer_Decorator extends Crossroads_API_Model_Serializer_Abstract {
    protected $inner = null;

    public function __construct(array $params = []) {
        parent::__construct($params);

        if(array_key_exists("inner", $params)) {
            $this->setInner($params["inner"]);
        }
    }

    /**
     * @param  Serializer<T>
     * @return self
     */
    public function setInner($inner) {
        $this->inner = $inner;

        return $this;
    }

    /**
     * @param  T
     * @return T
     */
    protected function preItem($item) {
        return $item;
    }

    /**
     * @param  T
     * @param  U
     * @return U
     */
    protected function postItem($item, $data) {
        return $data;
    }

    public function serializeItem($item) {
        $item = $this->preItem($item);

        return $this->postItem($item, $this->inner->serializeItem($item));
    }
}
