# Crossroads API module

A generic API module for Magento, provides a RESTful API.

[API Documentation](http://doc.crossroads.se/Crossroads-API/master)

## Requirements

* [Composer](https://getcomposer.org/download/)
* [Dibspw-module](http://groot.crossroads.se/modules/Dibspw-Official) (Optional‚ required for Dibs payment support)
* [Magento-Performance](https://groot.crossroads.se/modules/Magento-Performance) Optional but recommended for PHP 5. *Required for PHP 7*
* Magento 1.9.3.2 or greater
* [OrganicInternet's SimpleConfigurableProducts](https://github.com/organicinternet/magento-configurable-simple) if configurable products are used, otherwise their pricing will be weird.

## Composer.json

Add the following to your `composer.json`:

```
{
	"name": "Your project name",
	"description": "Your project description",
	"require": {
		"Crossroads_API": "dev-master",
		"magento-hackathon/magento-composer-installer": "*"
	},
	"repositories": [
		{
			"type": "composer",
			"url":  "https://composer.crossroads.se"
		}
	],
	"extra": {
		"magento-root-dir":      ".",
		"auto-append-gitignore": true
	}
}
```

## Development

When this module is installed in a project Composer clones the git reposiotry into `vendor/Crossroads_API`. It will then create hard-links according to the `extra.map` specification inside of `composer.json` of the `Crossroads_API` package.

To modify and develop the `Crossroads_API` module, modify files inside of `vendor/Crossroads_API` instead of `app/code/local/Crossroads/API`. Then commit and push like normal inside of `vendor/Crossroads_API`.

### Documentation

Documentation can be built using [node.js](https://nodejs.org/en/download/):

```
npm install
npm run doc
```

This will result in a `doc` directory in the project root with the API documentation.

## Configuration

Magento needs to allow symlinked templates if Composer is installing modules through symlinks
(this is the default, see [magento-composer-installer Deploy documentation](https://github.com/Cotya/magento-composer-installer/blob/3.0/doc/Deploy.md)).
In Magento Admin set `System` -> `Configuration` -> `Advanced` -> `Developer` -> `Template Settings`
-> `Allow Symlinks` to Yes.

### Web

To improve correctness and decrease the risk for weird bugs where the API
suddenly just responds with HTML:

* `System` -> `Configuration` -> `Web` -> `Url Options` -> `Auto-redirect to Base URL`: `No`

### Attributes

To improve performance greatly, turn on indexing of the `Manufacturer's Suggested Retail Price` attribute by
entering `Catalog` -> `Attributes` -> `Manage Attributes` -> `msrp` and setting:

* **Use In Layered Navigation**: `Filterable (with results)`
* **Use In Search Results Layered Navigation**: `Yes`
* **Visible on Product View Page on Front-end**: `Yes`
* **Used in Product Listing**: `Yes`
* **Used for Sorting in Product Listing**: `Yes`

### Price configuration

To correctly display prices in the returned data, configure the following settings to the
displayed values in Magento Admin -> `System` -> `Configuration` -> `Sales` -> `Tax`:

#### Price Display Settings:

* **Display Product Prices In Catalog:** `Including and Excluding Tax`
* **Display Shipping Prices:** `Including and Excluding Tax`

#### Shopping Cart Display Settings *and* Orders, Invoices, Credit Memos Display Settings

* **Display Prices:** `Including and Excluding Tax`
* **Display Subtotal:** `Including and Excluding Tax`
* **Display Shipping Amount:** `Including and Excluding Tax`
* **Display Full Tax Summary:** `Yes`
* **Display Zero Tax Subtotal:** `Yes`

## Nesting other modules under the `/api` namespace

Example from `Crossroads_ContactTradeIt` from TradeIt:

```xml
<config>
  <frontend>
    <routers>
      <API>
        <args>
          <modules>
            <contact_tradeit after="Crossroads_API">Crossroads_ContactTradeIt</contact_tradeit>
          </modules>
        </args>
      </API>
    </routers>
  </frontend>
</config>
```

The XML above will add controllers from the `Crossroads_ContactTradeIt` module in the `/api` namespace
to be resolved after attempting any controllers from the `Crossroads_API` module.

## Troubleshooting

* Some files got messed up and a reinstall of the module is required:

  ```
  composer run-script post-install-cmd -vvv -- --redeploy
  ```