<?php

abstract class Crossroads_API_Model_Serializer_Product_Abstract extends Crossroads_API_Model_Serializer_Abstract {
    const PRODUCT_CONFIGURABLE = "configurable";
    const PRODUCT_BUNDLE       = "bundle";
    const PRODUCT_SIMPLE       = "simple";
    const PRODUCT_VIRTUAL      = "virtual";

    /**
     * Obtains the MSRP for a given product, if it is a complex product will will find the smallest MSRP
     * of the child products.
     *
     * @internal
     *
     * @param  Mage_Catalog_Model_Product
     * @return double
     */
    protected function getMsrp(Mage_Catalog_Model_Product $product) {
        if ($product->getTypeId() !== self::PRODUCT_CONFIGURABLE) {
            return (double)$product->getMsrp();
        }

        $instance   = $product->getTypeInstance(true);
        $rawOptions = $instance->getConfigurableAttributesAsArray($product);
        $children   = array_filter($instance->getUsedProducts(null, $product), function($p) {
            return $p->isSaleable();
        });

        $msrps = [];

        foreach($rawOptions as $option) {
            foreach($children as $child) {
                foreach ($option["values"] as $value)  {
                    if ($child->getData($option["attribute_code"]) === $value["value_index"]) {
                        $msrp = $child->getMsrp();
                        if ($msrp) {
                            $msrps[] = $msrp;
                        }
                    }
                }
            }
        }

        return !empty($msrps) ? (double)min($msrps) : null;
    }
}
