<?php

abstract class Crossroads_API_Model_Collection_Abstract extends Mage_Core_Model_Abstract {
    const LIMIT_DEFAULT = 20;
    const LIMIT_MAX     = 200;

    protected $page     = 1;
    protected $pageSize = null;

    public function setLimit($limit = null) {
        $this->pageSize = min(max(is_numeric($limit) ? (int)$limit : static::LIMIT_DEFAULT, 0), static::LIMIT_MAX);

        return $this;
    }

    public function setPage($page = null) {
        $this->page = max(is_numeric($page) ? (int)$page : 1, 1);

        return $this;
    }

    /**
     * Prepares a collection for mapping.
     */
    public function prepare($collection) {
        // We call this directly on the select to prevent magento from stopping us from
        // going off the end of the list. (setCurPage() prevents this, which is not correct
        // from an API PoV)
        $collection->getSelect()
                   ->limitPage($this->page, $this->pageSize === null ? static::LIMIT_DEFAULT : $this->pageSize);

        return $collection;
    }

    public function createCollection() {
        return $this->prepare($this->newCollection());
    }

    protected abstract function newCollection();
}
