<?php

class Crossroads_API_Helper_Cms {
    /**
     * Executed after the page associated array has been prepared. This event allows
     * modification of the returned page associated array.
     *
     * Params:
     *  * page            The page object
     *  * prepared_data   The associated array as a varien object, note that the data is in
     *                    camel-case, so use setData and getData to modify.
     */
    const EVENT_PAGE_POST_DATA_PREPARE = "crossroads_api_page_post_data_prepare";

    /**
     * Executed after the list-data array has been prepared. This event allows
     * modification of the returned page associated array.
     *
     * Params:
     *  * page            The page object
     *  * prepared_data   The associated array as a varien object, note that the data is in
     *                    camel-case, so use setData and getData to modify.
     */
    const EVENT_PAGE_LIST_POST_DATA_PREPARE = "crossroads_api_page_list_post_data_prepare";

    public function getAll()
    {
        $store_id = Mage::app()->getStore()->getStoreId();
        $root_id  = Mage::app()->getStore($store_id)->getRootCategoryId();

        $pages = Mage::getModel('cms/page')
            ->getCollection()
            ->addStoreFilter($store_id)
            ->addFieldToFilter('is_active', 1);

        return array_values(array_map(function($page) {
            $data = new Varien_Object([
                "id"         => (int)$page->getPageId(),
                "title"      => $page->getTitle(),
                "urlKey"     => $page->getIdentifier(),
                "sortOrder"  => (int)$page->getSortOrder(),
            ]);

            Mage::dispatchEvent(self::EVENT_PAGE_LIST_POST_DATA_PREPARE, [
                "page"          => $page,
                "prepared_data" => $data,
            ]);

            return $data->getData();
        }, $pages->getItems()));
    }

    public function getItem($id)
    {
        $page = Mage::getModel('cms/page')->load($id);

        if( ! $id) {
            return null;
        }

        return $this->prepareCmsPage($page);
    }

    public function getCategoryIdByUrlKey($url_key)
    {
        return Mage::getModel('cms/page')->checkIdentifier($url_key, Mage::app()->getStore()->getId());
    }

    public function prepareCmsPage($page) {
        $helper    = Mage::helper('cms');
        $data      = $page->getData();
        $processor = $helper->getPageTemplateProcessor();
        $html      = $processor->filter($page->content);

        $pageData = new Varien_Object([
            "id"              => (int)$data["page_id"],
            "contentHeading"  => $data["content_heading"],
            "title"           => $data["title"],
            "urlKey"          => $data["identifier"],
            "isActive"        => $data["is_active"] > 0,
            "metaDescription" => $data["meta_description"],
            "metaKeywords"    => $data["meta_keywords"],
            "rootTemplate"    => $data["root_template"],
            "sortOrder"       => (int)$data["sort_order"],
            "createdAt"       => gmdate("Y-m-d\TH:i:s\Z", strtotime($data["creation_time"])),
            "updatedAt"       => gmdate("Y-m-d\TH:i:s\Z", strtotime($data["update_time"])),
            "html"            => $html
        ]);

        Mage::dispatchEvent(self::EVENT_PAGE_POST_DATA_PREPARE, [
            "page"          => $page,
            "prepared_data" => $pageData,
        ]);

        return $pageData->getData();
    }
}
