<?php

/**
 * Variant of the Groupprice serializer which will use the id of the product and a
 * store-id to obtain the group-price list which is then serialized. This is used
 * for partial product objects (like lists, lists of options and so on).
 *
 * Params:
 *  * storeId: integer
 */
class Crossroads_API_Model_Serializer_Groupprices_Loader extends Crossroads_API_Model_Serializer_Groupprices {
    protected $storeId = 0;

    public function __construct(array $params = []) {
        $this->storeId = $params["storeId"];

        parent::__construct($params);
    }

    /**
     * @param  Mage_Catalog_Model_Product
     * @return Array<["groupCode" => string|null, "price" => double]>
     */
    public function serializeItem($item) {
        return $this->serializeGroupPrices(
            Mage::getResourceSingleton("catalog/product_attribute_backend_groupprice")
                ->loadPriceData($item->getId(), $this->storeId));
    }
}
