<?php

class Crossroads_API_Model_Attribute {
    /**
     * @param Mage_Eav_Model_Attribute
     */
    public function fetchProductAttributeValues($attribute) {
        $flat      = Mage::helper("catalog/product_flat");
        $resource  = Mage::getResourceSingleton("catalog/product_flat");
        $db        = $resource->getReadConnection();
        $select    = $db->select();
        $groupId   = Mage::getSingleton("customer/session")->getCustomerGroupId();
        $websiteId = Mage::app()->getStore()->getWebsiteId();
        $attrs     = Mage::getSingleton("catalog/config")->getAttributesUsedInProductListing();

        if( ! array_key_exists("msrp", $attrs)) {
            Mage::throwException("Attribute msrp is not indexed in product flat table");
        }

        if( ! array_key_exists($attribute->getAttributeCode(), $attrs)) {
            Mage::throwException(sprintf("Attribute '%s' is not indexed in product flat table", $attribute->getAttributeCode()));
        }

        if( ! $flat->isEnabled()) {
            Mage::throwException("Flat table is not enabled");
        }

        $select->from(["p" => $resource->getFlatTableName()], []);

        $select->join(["f" => "catalog_product_index_price"], sprintf("p.entity_id = f.entity_id AND f.website_id = %d AND f.customer_group_id = %d", $websiteId, $groupId), []);

        $select->where("p.status = ?", Mage_Catalog_Model_Product_Status::STATUS_ENABLED);
        $select->where("p.type_id = ?", "simple");

        $select->columns([
            "id"          => "p." . $attribute->getAttributeCode(),
            "value"       => $attribute->usesSource() ? "p.".$attribute->getAttributeCode()."_value" : "p." . $attribute->getAttributeCode(),
            "maxDiscount" => "1 - MAX(f.final_price / p.msrp)",
        ]);

        $select->group(["p." . $attribute->getAttributeCode()]);

        return $db->query($select)->fetchAll(Zend_Db::FETCH_ASSOC);
    }
}
