<?php

/**
 * Constant variant of the stockinfo serializer which just returns null on all
 * stock properties.
 */
class Crossroads_API_Model_Serializer_Product_Stockinfo_Empty extends Crossroads_API_Model_Serializer_Product_Stockinfo {
    /**
     * Populates a stock-info structure with nulls.
     *
     * @param  Mage_Catalog_Model_Product
     * @return ["stockQty" => int|null, "stockBackorders" => boolean|null, "stockManage" => boolean|null]
     */
    public function serializeItem($_product) {
        return [
            "stockQty"        => null,
            "stockBackorders" => null,
            "stockManage"     => null,
        ];
    }
}
