<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

require_once("Mage.php");
require_once("Varien/Object.php");

require_once("Model/Serializer/Abstract.php");
require_once("Model/Serializer/Groupprices.php");
require_once("Model/Serializer/Groupprices/Loader.php");

/**
 * @covers Crossroads_API_Model_Serializer_Groupprices_Loader
 */
class Crossroads_API_Model_Serializer_Groupprices_LoaderTest extends TestCase {
    /**
     * @dataProvider prepareGroupPricesData
     */
    public function testPrepareGroupPrices($storeId, $websiteId) {
        $priceObj   = new stdClass;
        $groupObj   = new stdClass;
        $idObj      = new stdClass;
        $product    = $this->getMockBuilder(Mage_Catalog_Model_Product::class)
                           ->setMethods(["getId"])
                           ->getMock();
        $groupprice = $this->getMockBuilder(Mage_Catalog_Model_Product::class)
                           ->setMethods(["loadPriceData"])
                           ->getMock();
        $groups     = $this->getMockBuilder(stdClass::class)
                           ->setMethods(["getCollection"])
                           ->getMock();
        $collection = $this->getMockBuilder(stdClass::class)
                           ->setMethods(["getItems"])
                           ->getMock();
        $collection->expects($this->once())
                   ->method("getItems")
                   ->will($this->returnValue([]));

        $groups->expects($this->once())
               ->method("getCollection")
               ->will($this->returnValue($collection));

        Mage::_setModel("customer/group", $groups);

        $product->expects($this->once())
                ->method("getId")
                ->will($this->returnValue($idObj));
        $groupprice->expects($this->once())
                   ->method("loadPriceData")
                   ->with($this->identicalTo($idObj), $this->identicalTo($storeId))
                   ->will($this->returnValue($priceObj));
        $serializer = $this->getMockBuilder(Crossroads_API_Model_Serializer_Groupprices_Loader::class)
            ->setMethods(["serializeGroupPrices", "getCustomerGroups"])
            ->setConstructorArgs([[
                "websiteId" => $websiteId,
                "storeId"   => $storeId,
            ]])
            ->getMock();

        $serializer->expects($this->once())
                   ->method("serializeGroupPrices")
                   ->with($this->identicalTo($priceObj))
                   ->will($this->returnValue($groupObj));
        $serializer->expects($this->never())
                   ->method("getCustomerGroups");

        Mage::_setResourceSingleton("catalog/product_attribute_backend_groupprice", $groupprice);

        $prop = new ReflectionProperty($serializer, "websiteId");
        $prop->setAccessible(true);

        $this->assertSame($groupObj, $serializer->serializeItem($product));
        $this->assertSame($websiteId, $prop->getValue($serializer));
    }

    public function prepareGroupPricesData() {
        return [
            [0, 0],
            [4, 0],
            [0, 5],
            [4, 7],
        ];
    }
}
