<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

require_once("Mage.php");
require_once("Model/Serializer/Abstract.php");

/**
 * @covers Crossroads_API_Model_Serializer_Abstract
 */
class Crossroads_API_Model_Serializer_AbstractTest extends TestCase {
    public function testEmptyCollection() {
        $serializer = $this->getMockBuilder(Crossroads_API_Model_Serializer_Abstract::class)
                           ->setMethods(["serializeItem"])
                           ->getMock();
        $collection = $this->getMockBuilder(stdClass::class)
                           ->setMethods(["getItems"])
                           ->getMock();

        $serializer->expects($this->never())
                   ->method("serializeItem");
        $collection->expects($this->once())
                   ->method("getItems")
                   ->will($this->returnValue([]));

        $this->assertEquals($serializer->mapCollection($collection), []);
    }

    public function testCollection() {
        $o1         = new stdClass;
        $o1r        = new stdClass;
        $serializer = $this->getMockBuilder(Crossroads_API_Model_Serializer_Abstract::class)
                           ->setMethods(["serializeItem"])
                           ->getMock();
        $collection = $this->getMockBuilder(stdClass::class)
                           ->setMethods(["getItems"])
                           ->getMock();

        $serializer->expects($this->once())
                   ->method("serializeItem")
                   ->with($this->identicalTo($o1))
                   ->will($this->returnValue($o1r));
        $collection->expects($this->once())
                   ->method("getItems")
                   ->will($this->returnValue([
                       $o1,
                   ]));

        $this->assertSame($serializer->mapCollection($collection), [$o1r]);
    }

    public function testCollection2() {
        $o1         = new stdClass;
        $o1->_name  = "o1";
        $o1r        = new stdClass;
        $o1r->_name = "o1r";
        $o2         = new stdClass;
        $o2->_name  = "o2";
        $o2r        = new stdClass;
        $o2r->_name = "o2r";
        $serializer = $this->getMockBuilder(Crossroads_API_Model_Serializer_Abstract::class)
                           ->setMethods(["serializeItem"])
                           ->getMock();
        $collection = $this->getMockBuilder(stdClass::class)
                           ->setMethods(["getItems"])
                           ->getMock();

        $serializer->expects($this->exactly(2))
                   ->method("serializeItem")
                   ->withConsecutive([$o1], [$o2])
                   ->will($this->returnValueMap([
                       [$o1, $o1r],
                       [$o2, $o2r],
                   ]));
        $collection->expects($this->once())
                   ->method("getItems")
                   ->will($this->returnValue([
                       $o1,
                       $o2,
                   ]));

        $this->assertSame($serializer->mapCollection($collection), [$o1r, $o2r]);
    }

    public function testArray() {
        $o1         = new stdClass;
        $o1->_name  = "o1";
        $o1r        = new stdClass;
        $o1r->_name = "o1r";
        $o2         = new stdClass;
        $o2->_name  = "o2";
        $o2r        = new stdClass;
        $o2r->_name = "o2r";
        $serializer = $this->getMockBuilder(Crossroads_API_Model_Serializer_Abstract::class)
                           ->setMethods(["serializeItem"])
                           ->getMock();

        $serializer->expects($this->exactly(2))
                   ->method("serializeItem")
                   ->withConsecutive([$o1], [$o2])
                   ->will($this->returnValueMap([
                       [$o1, $o1r],
                       [$o2, $o2r],
                   ]));

        $this->assertSame($serializer->mapArray([
            $o1,
            $o2,
        ]), [$o1r, $o2r]);
    }

    public function testArray2() {
        $serializer = $this->getMockBuilder(Crossroads_API_Model_Serializer_Abstract::class)
                           ->setMethods(["serializeItem"])
                           ->getMock();

        $serializer->expects($this->never())
                   ->method("serializeItem");

        $this->assertSame($serializer->mapArray([]), []);
    }
}
