<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

require_once("Mage.php");

/**
 * @covers Mage
 */
class MageTest extends TestCase {
    /**
     * @covers Mage::helper
     * @expectedException RuntimeException
     */
    public function testHelperEmpty() {
        Mage::helper("test");
    }

    /**
     * @covers Mage::helper
     * @covers Mage::_setHelper
     */
    public function testHelper() {
        $h = new stdClass;

        Mage::_setHelper("test", $h);

        $this->assertSame(Mage::helper("test"), $h);
    }

    /**
     * @covers Mage::helper
     * @covers Mage::_setHelper
     */
    public function testHelperCallable() {
        $h = new stdClass;

        Mage::_setHelper("test", function() use($h) {
            $this->assertEquals([], func_get_args());

            return $h;
        });

        $this->assertSame($h, Mage::helper("test"));
    }

    /**
     * @covers Mage::getModel
     * @expectedException RuntimeException
     */
    public function testGetModelEmpty() {
        Mage::getModel("test");
    }

    /**
     * @covers Mage::getModel
     * @covers Mage::_setModel
     */
    public function testGetModel() {
        $h = new stdClass;

        Mage::_setModel("test", $h);

        $this->assertSame(Mage::getModel("test"), $h);
    }

    /**
     * @covers Mage::getModel
     * @covers Mage::_setModel
     */
    public function testGetModelCallable() {
        $h = new stdClass;

        Mage::_setModel("test", function() use($h) {
            $this->assertEquals([[]], func_get_args());

            return $h;
        });

        $this->assertSame($h, Mage::getModel("test"));
    }

    /**
     * @covers Mage::getModel
     * @covers Mage::_setModel
     */
    public function testGetModelCallable2() {
        $h = new stdClass;
        $a = new stdClass;

        Mage::_setModel("test", function() use($h, $a) {
            $this->assertEquals([[ "foo" => $a ]], func_get_args());

            return $h;
        });

        $this->assertSame($h, Mage::getModel("test", [ "foo" => $a ]));
    }

    /**
     * @covers Mage::getSingleton
     * @expectedException RuntimeException
     */
    public function testGetSingletonEmpty() {
        Mage::getSingleton("test");
    }

    /**
     * @covers Mage::getSingleton
     * @covers Mage::_setSingleton
     */
    public function testGetSingleton() {
        $h = new stdClass;

        Mage::_setSingleton("test", $h);

        $this->assertSame(Mage::getSingleton("test"), $h);
    }

    /**
     * @covers Mage::getSingleton
     * @covers Mage::_setSingleton
     */
    public function testGetSingletonCallable() {
        $h = new stdClass;

        Mage::_setSingleton("test", function() use($h) {
            $this->assertEquals([[]], func_get_args());

            return $h;
        });

        $this->assertSame($h, Mage::getSingleton("test"));
    }

    /**
     * @covers Mage::getSingleton
     * @covers Mage::_setSingleton
     */
    public function testGetSingletonCallable2() {
        $h = new stdClass;
        $a = new stdClass;

        Mage::_setSingleton("test", function() use($h, $a) {
            $this->assertEquals([[ "foo" => $a ]], func_get_args());

            return $h;
        });

        $this->assertSame($h, Mage::getSingleton("test", [ "foo" => $a ]));
    }

    /**
     * @covers Mage::getResourceSingleton
     * @expectedException RuntimeException
     */
    public function testGetResourceSingletonEmpty() {
        Mage::getResourceSingleton("test");
    }

    /**
     * @covers Mage::getResourceSingleton
     * @covers Mage::_setResourceSingleton
     */
    public function testGetResourceSingleton() {
        $h = new stdClass;

        Mage::_setResourceSingleton("test", $h);

        $this->assertSame(Mage::getResourceSingleton("test"), $h);
    }

    /**
     * @covers Mage::getResourceSingleton
     * @covers Mage::_setResourceSingleton
     */
    public function testGetResourceSingletonCallable() {
        $h = new stdClass;

        Mage::_setResourceSingleton("test", function() use($h) {
            $this->assertEquals([[]], func_get_args());

            return $h;
        });

        $this->assertSame($h, Mage::getResourceSingleton("test"));
    }

    /**
     * @covers Mage::getResourceSingleton
     * @covers Mage::_setResourceSingleton
     */
    public function testGetResourceSingletonCallable2() {
        $h = new stdClass;
        $a = new stdClass;

        Mage::_setResourceSingleton("test", function() use($h, $a) {
            $this->assertEquals([[ "foo" => $a ]], func_get_args());

            return $h;
        });

        $this->assertSame($h, Mage::getResourceSingleton("test", [ "foo" => $a ]));
    }

    /**
     * @covers Mage::dispatchEvent
     * @expectedException RuntimeException
     */
    public function testDispatchEventEmpty() {
        Mage::dispatchEvent("test", []);
    }

    /**
     * @covers Mage::dispatchEvent
     * @covers Mage::_setEventListener
     */
    public function testDispatchEvent() {
        $value = null;

        Mage::_setEventListener("test", function($v) use(&$value) {
            $value = $v;

            return "whatevs";
        });

        $this->assertSame(null, Mage::dispatchEvent("test", []));
        $this->assertSame([], $value);
    }

    /**
     * @covers Mage::dispatchEvent
     * @covers Mage::_setEventListener
     */
    public function testDispatchEvent2() {
        $value = null;
        $obj   = new stdClass;

        Mage::_setEventListener("test", function($v) use(&$value) {
            $value = $v;

            return "whatevs";
        });

        $this->assertSame(null, Mage::dispatchEvent("test", [ "a" => $obj ]));
        $this->assertSame([ "a" => $obj ], $value);
    }

    /**
     * @covers Mage::_clear
     * @expectedException RuntimeException
     */
    public function testClear() {
        Mage::_setEventListener("test", function() {});
        Mage::_clear();
        Mage::dispatchEvent("test", []);
    }

    /**
     * @covers Mage::_clear
     * @expectedException RuntimeException
     */
    public function testClear2() {
        Mage::_setModel("test", "foo");
        Mage::_clear();
        Mage::getModel("test");
    }

    /**
     * @covers Mage::_clear
     * @expectedException RuntimeException
     */
    public function testClear3() {
        Mage::_setHelper("test", "foo");
        Mage::_clear();
        Mage::helper("test");
    }

    /**
     * @covers Mage::_clear
     * @expectedException RuntimeException
     */
    public function testClear4() {
        Mage::_setSingleton("test", "foo");
        Mage::_clear();
        Mage::getSingleton("test", []);
    }

    /**
     * @covers Mage::_clear
     * @expectedException RuntimeException
     */
    public function testClear5() {
        Mage::_setResourceSingleton("test", "foo");
        Mage::_clear();
        Mage::getResourceSingleton("test", []);
    }

    /**
     * @covers Mage::_clear
     * @expectedException RuntimeException
     */
    public function testClear6() {
        Mage::_initConfig([]);
        Mage::_clear();
        Mage::app();
    }

    /**
     * @covers Mage::app
     * @expectedException RuntimeException
     */
    public function testAppEmpty() {
        Mage::app();
    }

    /**
     * @covers Mage::app
     */
    public function testApp() {
        Mage::_initConfig([]);
        $this->assertInstanceOf(MageApp::class, Mage::app());
    }
}
