<?php

require_once("Mage/Core/Model/Store.php");

// TODO: Write tests for this, need to make sure this works for the test-suite
/**
 * Test-shim for Magento's Mage class.
 */
class Mage {
    protected static $models     = [];
    protected static $singletons = [];
    protected static $helpers    = [];
    protected static $app        = null;
    protected static $events     = [];
    protected static $resSingle  = [];

    public static function _setModel($name, $model) {
        self::$models[$name] = $model;
    }

    public static function _setSingleton($name, $model) {
        self::$singletons[$name] = $model;
    }

    public static function _setHelper($name, $helper) {
        self::$helpers[$name] = $helper;
    }

    public static function _setResourceSingleton($name, $resource) {
        self::$resSingle[$name] = $resource;
    }

    public static function _initConfig($config) {
        self::$app = new MageApp($config);
    }

    public static function _clear() {
        self::$app        = null;
        self::$models     = [];
        self::$helpers    = [];
        self::$events     = [];
        self::$resSingle  = [];
        self::$singletons = [];
    }

    public static function _setEventListener($event, $listener) {
        self::$events[$event] = $listener;
    }

    public static function app() {
        if( ! self::$app) {
            throw new RuntimeException(sprintf("%s: \$app is not initialized, call Mage::_initConfig() in the test", __METHOD__));
        }

        return self::$app;
    }

    public static function helper($name) {
        if( ! array_key_exists($name, self::$helpers)) {
            throw new RuntimeException(sprintf("%s: Cannot find helper '%s'.", __METHOD__, $name));
        }

        $helper = self::$helpers[$name];

        if(is_callable($helper)) {
            return $helper();
        }

        return $helper;
    }

    public static function getModel($name, $arguments = []) {
        if( ! array_key_exists($name, self::$models)) {
            throw new RuntimeException(sprintf("%s: Cannot find model '%s'.", __METHOD__, $name));
        }

        $model = self::$models[$name];

        if(is_callable($model)) {
            return $model($arguments);
        }

        return $model;
    }

    public static function getSingleton($name, $arguments = []) {
        if( ! array_key_exists($name, self::$singletons)) {
            throw new RuntimeException(sprintf("%s: Cannot find singleton '%s'.", __METHOD__, $name));
        }

        $model = self::$singletons[$name];

        if(is_callable($model)) {
            return $model($arguments);
        }

        return $model;
    }

    public static function getResourceSingleton($name, $arguments = []) {
        if( ! array_key_exists($name, self::$resSingle)) {
            throw new RuntimeException(sprintf("%s: Cannot find resource singleton '%s'.", __METHOD__, $name));
        }

        $model = self::$resSingle[$name];

        if(is_callable($model)) {
            return $model($arguments);
        }

        return $model;
    }

    public static function dispatchEvent($name, $data) {
        if(array_key_exists($name, self::$events)) {
            self::$events[$name]($data);
        }
        else {
            throw new RuntimeException(sprintf("%s: Unexpected event dispatch '%s'.", __METHOD__, $name));
        }
    }
}

class MageApp {
    protected $store = null;

    public function __construct($config) {
        $this->store = array_key_exists("store", $config) ? new Mage_Core_Model_Store($config["store"]) : null;
    }

    public function getStore() {
        return $this->store;
    }
}
