<?php

class Crossroads_API_Checkout_TermsController extends Crossroads_API_Controller_Resource {
    /**
     * @api {get} /checkout_terms   List checkout terms
     * @apiName queryCheckoutTerms
     * @apiGroup Checkout
     * @apiDescription Lists all checkout Terms and Agreements which has to be agreed upon
     * to complete a checkout. All of the listed agreements require approval.
     *
     * @apiSuccess {Object[]} agreement
     * @apiSuccess {integer}  agreement.id
     * @apiSuccess {String}   agreement.name
     * @apiSuccess {String}   agreement.content
     * @apiSuccess {String}   [agreement.contentHeight]
     * @apiSuccess {String}   agreement.checkboxText
     * @apiSuccess {boolean}  agreement.isActive
     * @apiSuccess {boolean}  agreement.isHtml
     */
    public function getAll() {
        if( ! Mage::getStoreConfigFlag("checkout/options/enable_agreements")) {
            return [200, []];
        }

        $agreements = Mage::getModel("checkout/agreement")->getCollection()
            ->addStoreFilter(Mage::app()->getStore()->getId())
            ->addFieldToFilter("is_active", 1)
            ->getItems();

        return [200, array_values(array_map([$this, "prepareAgreement"], $agreements))];
    }

    public function getItem($_id) {
        return [404];
    }

    protected function prepareAgreement($agreement) {
        return [
            "id"            => (int)$agreement->getAgreementId(),
            "name"          => $agreement->getName(),
            "content"       => $agreement->getContent(),
            "contentHeight" => $agreement->getContentHeight(),
            "checkboxText"  => $agreement->getCheckboxText(),
            "isActive"      => (bool)$agreement->getIsActive(),
            "isHtml"        => (bool)$agreement->getIsHtml()
        ];
    }
}
