<?php

class Crossroads_API_Model_System_Config_Source_Productattrs {
    /**
     * Blacklist of attributes which are used in standard magento.
     */
    protected $ATTRIBUTE_BLACKLIST = [
        "select",
        "name",
        "groups",
        "product_view",
        "fields",
        "attributes",
        "attribute",
        "class",
        "style",
        "category_ids",
        "cost",
        "country_of_manufacture",
        "created_at",
        "custom_design",
        "custom_design_from",
        "custom_design_to",
        "custom_layout_update",
        "description",
        "ebizmarts_mark_visited",
        "gallery",
        "gift_message_available",
        "group_price",
        "has_s",
        "image_label",
        "is_recurring",
        "links_exist",
        "links_purchased_separately",
        "links_title",
        "media_gallery",
        "meta_description",
        "meta_keyword",
        "meta_title",
        "minimal_price",
        "modell",
        "msrp",
        "msrp_display_actual_price_type",
        "msrp_enabled",
        "old_id",
        "s_container",
        "page_layout",
        "price",
        "price_type",
        "price_view",
        "recurring_profile",
        "required_s",
        "samples_title",
        "shipment_type",
        "short_description",
        "sku",
        "sku_type",
        "small_image_label",
        "special_from_date",
        "special_price",
        "special_to_date",
        "status",
        "tax_class_id",
        "thumbnail_label",
        "tier_price",
        "updated_at",
        "url_key",
        "url_path",
        "visibility",
        "weight",
        "weight_type",
        "has_options",
        "options_container",
        "required_options"
    ];

    public function __construct() {
        $blacklist  = $this->ATTRIBUTE_BLACKLIST;
        $attributes = Mage::getResourceModel("catalog/product_attribute_collection")->getItems();

        $this->attributes = array_filter(array_map(function($a) use($blacklist) {
            if(in_array($a->getAttributeCode(), $blacklist)) {
                return false;
            }

            return $a->getData();
        }, $attributes));
    }

    public function toOptionArray() {
        return $this->attributes;
    }
}
