<?php

class Crossroads_API_Model_Serializer_Wishlist extends Crossroads_API_Model_Serializer_Abstract {
    /**
     * Executed after the basic wishlist associated array has been prepared. This event allows
     * modification of the returned wishlist associated array.
     *
     * Params:
     *  * wishlist        The wishlist object
     *  * prepared_data   The associated array as a varien object, note that the data is in
     *                    camel-case, so use setData and getData to modify.
     */
    const EVENT_WISHLIST_POST_DATA_PREPARE = "crossroads_api_wishlist_post_data_prepare";

    protected $item = null;

    public function __construct(array $params = []) {
        $this->item = $params["item"];

        parent::__construct($params);
    }

    /**
     * Formats a wishlist for JSON output.
     *
     * @param  Mage_Wishlist_Model_Wishlist
     * @return array
     */
    public function serializeItem($wishlist) {
        $wishlistData = new Varien_Object([
            "items"     => $this->item->mapCollection($wishlist->getItemCollection()),
            "shareCode" => $wishlist->getSharingCode()
        ]);

        Mage::dispatchEvent(self::EVENT_WISHLIST_POST_DATA_PREPARE, [
            "wishlist"      => $wishlist,
            "prepared_data" => $wishlistData
        ]);

        return $wishlistData->getData();
    }
}
