<?php

/**
 * Serializes product counts for categories.
 *
 * Params:
 *  * collection: Crossroads_API_Model_Collection_Product_Category
 */
class Crossroads_API_Model_Serializer_Category_Productcount extends Crossroads_API_Model_Serializer_Abstract {
    public function __construct(array $params = []) {
        $this->collCtor = $params["collection"];
    }

    /**
     * @param  Mage_Catalog_Model_Category
     * @return integer
     */
    public function serializeItem($category) {
        // Does not matter that we set a page and pageSize in the collCtor, getSize resets those in the query
        return $this->collCtor->setCategory($category)->createCollection()->getSize();
    }
}
