<?php

class Crossroads_API_Model_Serializer_Category extends Crossroads_API_Model_Serializer_Abstract {
    /**
     * Executed after the basic category associated array has been prepared. This event allows
     * modification of the returned category associated array.
     *
     * Params:
     *  * category        The category object
     *  * prepared_data   The associated array as a varien object, note that the data is in
     *                    camel-case, so use setData and getData to modify.
     *  * include_images  Boolean, if the user (or action) requests that images should be included
     */
    const EVENT_CATEGORY_POST_DATA_PREPARE = "crossroads_api_category_post_data_prepare";

    protected $productCount  = null;
    protected $includeImages = false;

    public function __construct(array $params = []) {
        $this->productCount = $params["productCount"];

        array_key_exists("includeImages", $params) && $this->includeImages = $params["includeImages"];

        parent::__construct($params);
    }

    /**
     * @param  Mage_Catalog_Model_Category
     * @return array
     */
    public function serializeItem($category) {
        $catData = new Varien_Object([
            "id"              => (int)$category->getEntityId(),
            "name"            => $category->getName(),
            "description"     => $category->getDescription(),
            "metaDescription" => $category->getMetaDescription(),
            "urlKey"          => $category->getUrlKey(),
            "url"             => $category->getUrlPath(),
            "position"        => (int)$category->getPosition(),
            "level"           => (int)$category->getLevel(),
            "isAnchor"        => $category->getIsAnchor() > 0,
            "path"            => $category->getPath(),
            "parentId"        => (int)$category->getParentId(),
            "metaTitle"       => $category->getMetaTitle(),
            "includeInMenu"   => $category->getIncludeInMenu() > 0,
            "productCount"    => $this->productCount->serializeItem($category),
        ]);

        Mage::dispatchEvent(self::EVENT_CATEGORY_POST_DATA_PREPARE, [
            "category"       => $category,
            "prepared_data"  => $catData ,
             "include_images" => $this->includeImages
        ]);

        return $catData->getData();
    }
}
