<?php

/**
 * Collection filtering products based on ids.
 */
class Crossroads_API_Model_Collection_Product_Byids extends Crossroads_API_Model_Collection_Product {
    protected $productIds = [];

    /**
     * Sets the list of product ids to filter by.
     */
    public function setProductIds(array $productIds) {
        $this->productIds = $productIds;

        return $this;
    }

    /**
     * Adds product ids to the list of product ids to filter by.
     */
    public function addProductIds(array $productIds) {
        $this->productIds = array_unique(array_merge($this->productIds, $productIds));

        return $this;
    }

    /**
     * Add a product id to the list of product ids to filter by.
     */
    public function addProductId($productId) {
        $this->productIds[] = $productId;

        return $this;
    }

    public function prepare($collection) {
        return $collection->addAttributeToFilter("id", [ "in" => $this->productIds ]);
    }
}
