<?php

class Crossroads_API_Model_Attribute {
    /**
     * Lists all attribute value combinations for in-stock products for a
     * given attribute.
     *
     * @param Mage_Eav_Model_Attribute
     */
    public function fetchProductAttributeValues($attribute) {
        $flat      = Mage::helper("catalog/product_flat");
        $resource  = Mage::getResourceSingleton("catalog/product_flat");
        $db        = $resource->getReadConnection();
        $groupId   = Mage::getSingleton("customer/session")->getCustomerGroupId();
        $websiteId = Mage::app()->getStore()->getWebsiteId();
        $attrs     = Mage::getSingleton("catalog/config")->getAttributesUsedInProductListing();
        $transact  = Mage::helper("API/transaction");
        $attrValue = $attribute->usesSource() ? "p.".$attribute->getAttributeCode()."_value" : "p." . $attribute->getAttributeCode();

        if( ! array_key_exists("msrp", $attrs)) {
            Mage::throwException("Attribute msrp is not indexed in product flat table");
        }

        if( ! array_key_exists($attribute->getAttributeCode(), $attrs)) {
            Mage::throwException(sprintf("Attribute '%s' is not indexed in product flat table", $attribute->getAttributeCode()));
        }

        if( ! $flat->isEnabled()) {
            Mage::throwException("Flat table is not enabled");
        }

        return $transact->withIsolationLevel($db, Crossroads_API_Helper_Transaction::READ_UNCOMMITTED, function($tx) use($attribute, $resource, $websiteId, $groupId, $attrValue) {
            $select = $tx->select();

            $select->from(["p" => $resource->getFlatTableName()], []);

            $select->join(["f" => "catalog_product_index_price"], sprintf("p.entity_id = f.entity_id AND f.website_id = %d AND f.customer_group_id = %d", $websiteId, $groupId), []);

            $select->where("p.status = ?", Mage_Catalog_Model_Product_Status::STATUS_ENABLED);
            $select->where("p.type_id IN (?)", ["simple", "virtual"]);

            $select->columns([
                "id"          => "p." . $attribute->getAttributeCode(),
                "value"       => $attrValue,
                "maxDiscount" => "1 - MAX(f.final_price / p.msrp)",
            ]);

            $select->group(["p." . $attribute->getAttributeCode()]);
            $select->order($attrValue);

            return $tx->query($select)->fetchAll(Zend_Db::FETCH_ASSOC);
        });
    }
}
