<?php

class Crossroads_API_Helper_Transaction extends Mage_Core_Helper_Abstract {
    const REPEATABLE_READ  = "REPEATABLE READ";
    const READ_COMMITTED   = "READ COMMITTED";
    const READ_UNCOMMITTED = "READ UNCOMMITTED";
    const SERIALIZABLE     = "SERIALIZABLE";
    const ISOLATION_LEVELS = [
        self::REPEATABLE_READ,
        self::READ_COMMITTED,
        self::READ_UNCOMMITTED,
        self::SERIALIZABLE,
    ];

    public function isValidIsolationLevel($level) {
        return in_array($level, self::ISOLATION_LEVELS, true);
    }

    public function assertValidIsolationLevel($level) {
        if( ! $this->isValidIsolationLevel($level)) {
            throw new RuntimeException(sprintf("Invalid transaction isolation level '%s'.", $level));
        }
    }

    /**
     * Rusn the supplied close with a different transaction isolation level
     * provided we are not in a transaction. The return value from the close
     * will be the return value of this method.
     */
    public function withIsolationLevel(Magento_Db_Adapter_Pdo_Mysql $db, $level, $func) {
        $this->assertValidIsolationLevel($level);

        if( ! $db->isTransaction()) {
            // MySQL returns the transaction isolation level hyphenated
            $isolation = strtoupper(str_replace("-", " ", $db->query("SELECT @@TX_ISOLATION")->fetchColumn()));

            $this->assertValidIsolationLevel($isolation);


            $db->exec(sprintf("SET SESSION TRANSACTION ISOLATION LEVEL %s", $level));
        }

        $result = $func($db);

        if( ! $db->isTransaction()) {
            $db->exec(sprintf("SET SESSION TRANSACTION ISOLATION LEVEL %s", $isolation));
        }

        return $result;
    }
}
