<?php

/**
 * Reads attributes from a magento entity according to configuration and presents them
 * in a key-value map.
 */
class Crossroads_API_Model_Serializer_Attributes extends Crossroads_API_Model_Serializer_Product_Abstract {
    protected $attributes = [];

    public function __construct(array $params = []) {
        $this->attributes = $params;

        parent::__construct([]);
    }

    /**
     * @param  Mage_Core_Model_Abstract
     * @return Array<string, mixed>
     */
    public function serializeItem($item) {
        // TODO: Move getEntityAttributes inline
        return Mage::helper("API/attributes")->getEntityAttributes($item, $this->attributes);
    }
}
