<?php

class Crossroads_API_Model_Eav_Entity_Attribute_Source_Paymentmethod extends Mage_Eav_Model_Entity_Attribute_Source_Abstract {
    public function getAllOptions() {
        $customer = Mage::registry("current_customer");

        $store = Mage::helper("API/customer")->getStoreIdForCustomer($customer);
        $store = $store ? Mage::getModel("core/store")->load($store) : null;

        $values = array_values(array_map(function($p) {
            return [
                "label" => sprintf("%s (%s)", $p->getTitle(), $p->getCode()),
                "value" => $p->getCode(),
            ];
        }, Mage::helper("API/payment")->getEnabledMethods(null, $store)));

        array_unshift($values, [
            "label" => "–",
            "value" => null,
        ]);

        return $values;
    }

    public function toOptionArray() {
        return $this->getAllOptions();
    }
}
