<?php

class Crossroads_API_Model_Collection_Product_Fulltext extends Crossroads_API_Model_Collection_Product {
    // protected $visibility        = ["eq" => Mage_Catalog_Model_Product_Visibility::VISIBILITY_IN_SEARCH];
    protected $searchQuery       = null;
    protected $matchedProductIds = null;

    protected function getQueryModel() {
        $query   = Mage::getModel("catalogsearch/query");

        $query->setStoreId($this->storeId);
        $query->loadByQuery($this->searchQuery);

        if( ! $query->getId()) {
            $query->setQueryText($this->searchQuery);
            $query->setStoreId($this->storeId);
            $query->setPopularity(1);
        }
        else {
            $query->setPopularity($query->getPopularity() + 1);
        }

        $query->prepare();

        return $query;
    }

    public function setSearchQuery($query) {
        $this->searchQuery       = $query;
        $this->matchedProductIds = null;

        return $this;
    }

    /**
     * Performs the search and saves the result, returning the list of matched product ids.
     *
     * Will not perform the search multiple times if called with the same search query.
     *
     * @return Array<int>
     */
    protected function search() {
        if(is_null($this->matchedProductIds)) {
            $query = $this->getQueryModel();

            $fulltextResource = Mage::getResourceModel("catalogsearch/fulltext")
                ->prepareResult(
                    Mage::getModel("catalogsearch/fulltext"),
                    $this->searchQuery,
                    $query
                );

            $this->matchedProductIds = array_keys($fulltextResource->getFoundData());

            $query->save();
        }

        return $this->matchedProductIds;
    }

    public function getSearchCount() {
        return count($this->search());
    }

    public function prepare($collection) {
        return parent::prepare($collection->addIdFilter($this->search()));
    }
}
