<?php

class Crossroads_API_SearchController extends Crossroads_API_Controller_Super
{
    protected function getQueryModel($queryText) {
        $storeId = Mage::app()->getStore()->getId();
        $query   = Mage::getModel("catalogsearch/query");

        $query->setStoreId($storeId);
        $query->loadByQuery($queryText);

        if( ! $query->getId()) {
            $query->setQueryText($queryText);
            $query->setStoreId($storeId);
            $query->setPopularity(1);
        }
        else {
            $query->setPopularity($query->getPopularity() + 1);
        }

        $query->prepare();

        return $query;
    }

    /**
     * @api {get} /search?query=:query Search products
     * @apiName search
     * @apiGroup Search
     * @apiDescription We'll need to implement our own algorithm here later.
     *
     * @apiParam {String} query Search query
     * @apiParam {Integer} [limit=20] The pagination size, max 100
     * @apiParam {Integer} [page=1] The pagination page
     *
     * @apiSuccess {Object[]} products Array of resulting products
     * @apiSuccess {Integer}  products.id Product id
     * @apiSuccess {String}   products.type Product type
     * @apiSuccess {String}   products.sku
     * @apiSuccess {String}   products.urlKey
     * @apiSuccess {Double}   products.price
     * @apiSuccess {Double}   products.specialPrice
     * @apiSuccess {Double}   products.msrp
     * @apiSuccess {Double}   products.discountPercent
     * @apiSuccess {String}   products.shortDescription
     * @apiSuccess {Mixed}    products.manufacturer String if a manufacturer is set, null otherwise
     * @apiSuccess {String}   products.smallImage
     * @apiSuccess {Boolean}  products.isSalable
     * @apiSuccess {Object[]} products.options  Null if simple product, object if complex, can be turned off in list view through System Configuration
     * @apiSuccess {String}   query   Used search query
     * @apiSuccess {Integer}  totalCount Total number of search hits
     */
    public function indexAction() {
        $search_query = $this->getRequest()->getParam("query");
        $pageSize     = min((int)$this->getRequest()->getQuery("limit", "20"), 100);
        $page         = max((int)$this->getRequest()->getQuery("page", "1"), 1);

        if (!$search_query) {
            return $this->sendData([404]);
        }

        $helper = Mage::helper("API/product");
        $query  = $this->getQueryModel($search_query);

        $fulltextResource = Mage::getResourceModel('catalogsearch/fulltext')->prepareResult(
            Mage::getModel('catalogsearch/fulltext'),
            $search_query,
            $query
        );

        $matchedProductIds = array_keys($fulltextResource->getFoundData());

        $collection = Mage::getResourceModel('catalog/product_collection')
            ->addIdFilter($matchedProductIds)
            ->addAttributeToSelect('*')
            ->addMinimalPrice();
        // We call this directly on the select to prevent magento from stopping us from
        // going off the end of the list. (setCurPage() prevents this, which is not correct
        // from an API PoV)
        $collection->getSelect()->limitPage($page, $pageSize);
        $collection->load();

        $data = $collection->getItems();

        $query->save();

        return $this->sendData([200, [
            "products"   => array_values(array_map(function($p) use($helper) {
                return $helper->prepareListProduct($p);
            }, $data)),
            "query"      => $search_query,
            "totalCount" => count($matchedProductIds)
        ]]);
    }
}