<?php

class Crossroads_API_ProductsController extends Crossroads_API_Controller_Resource
{
    public function getAll() {
        return [404];
    }

    /**
     * @api {get} /products/:id Get single product
     * @apiName getProduct
     * @apiGroup Product
     *
     * @apiParam {Integer} id The id of the product
     *
     * @apiSuccess {Integer} id                      Product ID
     * @apiSuccess {String}  type                    Product type (simple, configurable etc...)
     * @apiSuccess {String}  name                    Product name
     * @apiSuccess {String}  sku                     Product SKU
     * @apiSuccess {Double}  price                   Product price, includes price rules
     * @apiSuccess {Double}  [specialPrice]          Product special price
     * @apiSuccess {Object[]} [groupPrices]          Group prices, if enabled
     * @apiSuccess {String}   groupPrices.groupCode
     * @apiSuccess {Double}   groupPrices.price
     * @apiSuccess {Double}  originalPrice           Original product price
     * @apiSuccess {Double}  msrp                    Product list price
     * @apiSuccess {Double}  [discountPercent]
     * @apiSuccess {Double}  [stockQty]              Amount in stock, null if information not available
     * @apiSuccess {boolean} [stockBackorders]       True if backorders are allowed for the product, null if data not loaded
     * @apiSuccess {boolean} [stockManage]           True if stock is managed, if false any amount can be ordered, null if data not loaded
     * @apiSuccess {String}  shortDescription        Short description
     * @apiSuccess {String}  description             Long description
     * @apiSuccess {String}  metaDescription         Meta description
     * @apiSuccess {Object}  attributes              Key value pairs of the selected attributes in API_section/product_view/attributes
     * @apiSuccess {String}  imageLarge              Original product image
     * @apiSuccess {String}  imageMedium             Large product image
     * @apiSuccess {String}  imageSmall              Small product image
     * @apiSuccess {mixed}   [mediaGallery]          Product gallery array, can be null if deactivated or empty if no images are present
     * @apiSuccess {String}  [mediaGallery.thumbnail]  Thumbnail image
     * @apiSuccess {String}  [mediaGallery.largeImage] Large image
     * @apiSuccess {Boolean} isInStock               If product is in stock (this needs to be enabled set in admin settings)
     * @apiSuccess {Boolean}   isSalable               If product is salable
     * @apiSuccess {Object[]} [options]                 Null if simple product, array if complex
     * @apiSuccess {Integer}   options.id
     * @apiSuccess {String}    options.title
     * @apiSuccess {Boolean}   options.useAsDefault
     * @apiSuccess {Integer}   options.position
     * @apiSuccess {Object[]}  options.values
     * @apiSuccess {Integer}   options.values.id
     * @apiSuccess {String}    options.values.label
     * @apiSuccess {Boolean}   options.values.isPercent
     * @apiSuccess {Mixed}     options.values.price    null if not set
     * @apiSuccess {Object[]} [selections]
     * @apiSuccess {Integer}   selections.id
     * @apiSuccess {Boolean}   selections.required
     * @apiSuccess {Integer}   selections.position
     * @apiSuccess {String}    selections.type   Type of selection: `checkbox`, `select`, `multi` and `radio`
     * @apiSuccess {String}    selections.title
     * @apiSuccess {Object[]}  selections.options
     * @apiSuccess {Integer}   selections.options.id
     * @apiSuccess {Boolean}   selections.options.isDefault
     * @apiSuccess {Integer}   selections.options.qty
     * @apiSuccess {Boolean}   selections.options.isQtyFixed   If the quantity is fixed
     * @apiSuccess {String}    selections.options.name
     * @apiSuccess {String}    selections.options.shortDescription
     * @apiSuccess {String}    selections.options.smallImage
     * @apiSuccess {String}    selections.options.largeImage
     * @apiSuccess {String}    selections.options.originalImage
     * @apiSuccess {Boolean}   selections.options.isInStock
     * @apiSuccess {Boolean}   selections.options.isSalable
     * @apiSuccess {Integer}   selections.options.stockQty
     * @apiSuccess {Object[]}  [selections.options.groupPrices]
     * @apiSuccess {String}    selections.options.groupPrices.groupCode
     * @apiSuccess {Double}    selections.options.groupPrices.price
     * @apiSuccess {Double}    selections.options.price
     * @apiSuccess {Double}    selections.options.msrp
     * @apiSuccess {Object}    selections.options.attributes Key value pairs of the selected attributes in API_section/product_view/attributes
     * @apiSuccess {Integer[]} categoryIds   List of category ids this product can be found in
     * @apiSuccess {Object[]}  [customOptions]  If the product has custom options these will be listed here
     * @apiSuccess {Integer}   customOptions.id   ID used when specifying customOptions in cart
     * @apiSuccess {String}    customOptions.type  Type of option, see Mage_Catalog_Model_Product_Option constants
     * @apiSuccess {Boolean}   customOptions.required
     * @apiSuccess {Integer}   customOptions.maxLength
     * @apiSuccess {String}    customOptions.title
     * @apiSuccess {Double}    customOptions.price
     * @apiSuccess {Object[]}  customOptions.values  List of values for select, not present for some types
     * @apiSuccess {String}    customOptions.values.sku  Option value identifier, specify as value of the id
     * @apiSuccess {String}    customOptions.values.title
     * @apiSuccess {Double}    customOptions.values.price
     * @apiSuccess {Object[]}  relatedProducts        Related products
     * @apiSuccess {Integer}   relatedProducts.id
     * @apiSuccess {String}    relatedProducts.type
     * @apiSuccess {String}    relatedProducts.name
     * @apiSuccess {String}    relatedProducts.sku
     * @apiSuccess {String}    relatedProducts.urlKey
     * @apiSuccess {Double}    relatedProducts.price
     * @apiSuccess {Double}    relatedProducts.specialPrice
     * @apiSuccess {Object[]}  [relatedProducts.groupPrices]
     * @apiSuccess {String}    relatedProducts.groupPrices.groupCode
     * @apiSuccess {Double}    relatedProducts.groupPrices.price
     * @apiSuccess {Double}    relatedProducts.originalPrice
     * @apiSuccess {Double}    relatedProducts.msrp
     * @apiSuccess {Double}    relatedProducts.discountPercent
     * @apiSuccess {String}    relatedProducts.shortDescription
     * @apiSuccess {String}    relatedProducts.thumbImage
     * @apiSuccess {String}    relatedProducts.smallImage
     * @apiSuccess {Boolean}   relatedProducts.isSalable
     * @apiSuccess {Integer}   relatedProducts.position
     * @apiSuccess {Object}    relatedProducts.attributes Key value pairs of the selected attributes in API_section/product_view/attributes
     */
    public function getItem($id)
    {
        $product = Mage::getModel('catalog/product')->load($id);

        if( ! $product || ! $product->getId() || ! $product->isVisibleInSiteVisibility() || $product->isDisabled()) {
            throw Crossroads_API_ResponseException::create(404, 'Product is missing.', null, 1000);
        }

        return [200, Mage::helper("API/product")->prepareProductDetail($product)];
    }
}
