<?php

class Crossroads_API_Helper_Shipping {
    public function getAllShippingRatesForCustomer($customer) {
        $request     = Mage::getModel('shipping/rate_request');
        $fakeProduct = Mage::getModel("catalog/product");

        if($customer) {
            $shippingAddr = $customer->getDefaultShippingAddress();

            $request->setStoreId($customer->getStoreId());

            if($shippingAddr && $shippingAddr->getCountryId()) {
                $request->setDestCountryId($shippingAddr->getCountryId());
            }
            if($shippingAddr && $shippingAddr->getRegionId()) {
                $request->setDestRegionId($shippingAddr->getRegionId());
            }
            if($shippingAddr && $shippingAddr->getRegionCode()) {
                $request->setDestRegionCode($shippingAddr->getRegionCode());
            }
            if($shippingAddr && $shippingAddr->getPostcode()) {
                $request->setDestPostcode($shippingAddr->getPostcode());
            }

            if($customer->getCustomerGroupId()) {
                $request->setCustomerGroupId($customer->getCustomerGroupId());
                $fakeProduct->setCustomerGroupId($customer->getCustomerGroupId());
            }
        }

        $fakeItem = Mage::getModel("sales/quote_item")
            ->setQty(1)
            ->setProduct($fakeProduct);

        $request->setFreeMethodWeight(0);
        $request->setFreeShipping(false);
        $request->setOrig(true);
        $request->setAllItems([$fakeItem]);

        return Mage::getModel('shipping/shipping')->collectRates($request)->getResult()->getAllRates();
    }

    public function isValidShippingMethod($customer, $method) {
        foreach($this->getAllShippingRatesForCustomer($customer) as $r) {
            if(sprintf("%s_%s", $r->getCarrier(), $r->getMethod()) === $method) {
                return true;
            }
        }

        return false;
    }
}
