<?php

class Crossroads_API_Helper_Wishlist
{
    /**
     * Executed after the basic wishlist associated array has been prepared. This event allows
     * modification of the returned wishlist associated array.
     *
     * Params:
     *  * wishlist        The wishlist object
     *  * prepared_data   The associated array as a varien object, note that the data is in
     *                    camel-case, so use setData and getData to modify.
     */
    const EVENT_WISHLIST_POST_DATA_PREPARE = "crossroads_api_wishlist_post_data_prepare";

    /**
     * Formats a wishlist for JSON output.
     *
     * @param  Mage_Wishlist_Model_Wishlist
     * @return array
     */
    public function formatWishlist($wishlist) {
        $items = array_values($wishlist->getItemCollection()->getItems());

        $wishlistData = new Varien_Object([
            "items"      => array_map(function($p) {
                return Mage::helper("API/Product")->prepareCartProduct($p);
            }, $items),
            "shareCode" => $wishlist->getSharingCode()
        ]);

        Mage::dispatchEvent(self::EVENT_WISHLIST_POST_DATA_PREPARE, [
            "wishlist"      => $wishlist,
            "prepared_data" => $wishlistData
        ]);

        return $wishlistData->getData();
    }
}