# Documentation for error cores

The API will return an error code whenever a user-caused error occurs (ie. the HTTP status-code
is `< 500`).

Invalid Server Error (HTTP status-code 500) do not use this format unless Developer Mode is turned
on, and then they instead contain an exception and `errorCode = null`.

## Responses

The API will return an error in the style of:

```
{
  "message":   "Human readable message intended for developers, not translated.",
  "errorCode": 1234,
  "data":      null
}
```

### `message`

This message is not intended to be shown for normal users, it is technical in nature and
sheds some light on what went wrong. It is intended to be used by application-developers
when they need to fix issues where data might be missing, malformed or invalid.

### `errorCode`

This error code is unique per error, and grouped per error kind. To obtain messages for
normal users it is recommended to use this code to look up a suitable error message to
show.

A backup message might be necessary, for the case of when errors are missing error codes.

### `data`

Contains additional information about the error, does not have any specific format.

## Codes

All error codes which are common across all installations of this API are listed below and start
at `1000` and increasing.

Project-specific error-codes are in the range `1`–`999` and implemented in the specific
magento-installations as add-on-modules.

Application-specific error-codes should preferably be negative, since it will make it easy to
differentiate between an error from the API (server) and the application (client). An error code
of `0` should not happen normally (this is usually indicative of a bug in error-handling code
somewhere).

### General

 * **1000:** Product missing
 * **1001:** Failed to parse JSON data in request body when `Content-Type` is `application/json`.
 * **1002:** Malformed parentId parameter given to `/categories/`.
 * **1003:** Input for entity attribute expected scalar, got array or object.
 
### Cart

 * **2000:** This product is currently out of stock.
 * **2001:** The requested quantity is not available.
 * **2002:** Pleace specify a product option.
 * **2003:** Unable to add item to cart.
 * **2004:** Please specify a product and quantity.
 * **2005:** Please specify a product.
 * **2006:** Product could not be found.
 * **2007:** A product coult not be found in the cart.
 * **2008:** Unable to add item to cart.
 * **2009:** Product could not be found.
 * **2010:** Maximum quantity of requested product exceeded.
 * **2011:** Request body must have an items array.
 * **2012:** Unable to add item to cart.
 * **2013:** Required options are not selected.
 * **2014:** Unable to add item to cart.
 * **2015:** Selected options are not available on the specified product.

### Customer

 * **3000:** Customer is not logged in.
 * **3001:** Customer registration is disabled.
 * **3002:** Customer is missing email.
 * **3003:** Customer data must be an object.
 * **3004:** Customer data failed validation.
 * **3005:** Customer email address is already in use.
 * **3006:** Invalid email or password.
 * **3007:** Customer address failed to validate.
 * **3008:** Address data must be an object.
 * **3009:** New customer email address is already in use.
 * **3010:** Email field is missing
 * **3011:** Customer not found
 * **3012:** Missing 'email' parameter

### Checkout

 * **4000:** Payment method value must be a string.
 * **4002:** Delivery method value must be a string.
 * **4003:** Faulty delivery method
 * **4004:** Could not find cart
 * **4005:** The specified address contains an error.
 * **4006:** The specified address could not be verified.
 * **4007:** An error occured.
 * **4008:** Your cart is empty.
 * **4009:** Delivery address could not be verified.
 * **4010:** Please specify a delivery method.
 * **4011:** Invoicing address could not be verified.
 * **4012:** Please specify a payment method.
 * **4013:** We are experiencing issues with the requested payment method. Please try another one.
 * **4014:** Could not verify payment data.
 * **4015:** An error occurred.
 * **4016:** The requested payment method is not available.
 * **4017:** Required Terms and Conditions were not agreed to.
 * **4018:** Checkout requires agreements and agreements property must be an array.
 * **4019:** Invalid email address supplied

### Dibs

See http://groot.crossroads.se/modules/Crossroads-API-Dibspw and http://groot.crossroads.se/modules/Dibspw-Official

 * **6000:** Order number missing.
 * **6001:** Could not verify cart payment data from payment gateway.
 * **6002:** Order not found.

### Klarna

See http://groot.crossroads.se/modules/Klarna-Unofficial

 * **11000:** General Klarna error, look at `data.klarnaErrorCode` and `data.klarnaMessage`.
 * **11001:** Missing required `paymentMethodData.socialSecurityNumber`.
 * **11002:** Missing or malformed `paymentMethodData.klarnaPclass`, integer required.
 * **11003:** The chosen klarnaPclass is not enabled.
 * **11004:** Payment denied.

### Collector Bank

See https://groot.crossroads.se/modules/Collector

* **12001:** Invalid registration number
* **12002:** Denied purchase
* **12003:** Credit check denied
* **12004:** Address not found
* **12005:** Reservation not approved
* **12006:** Purchase amount too large
* **12007:** Agreement rules validation failed, supplied information does not match
* **12008:** Missing required paymentMethodData.socialSecurityNumber
* **12009:** Missing required payment[socialSecurityNumber] in Magento payment
