<?php

class Crossroads_API_Helper_Data extends Mage_Core_Helper_Abstract
{
    /**
     * Makes sure we have support for free payment in API.
     */
    public function registerPayment(Varien_Event_Observer $observer) {
        $observer->getRegistry()->addMethod(new Crossroads_API_Payment_Free());
    }

    /**
     * This function adds additional attributes to the quote-item data, matching what
     * `Crossroads_API_Helper_Product::prepareCartProduct` adds to `attributes`.
     */
    public function addQuoteProductAttributes($event) {
        $store      = Mage::app()->getStore();
        $attributes = $event->getAttributes();

        $config = unserialize($store->getConfig("API_section/attributes/product_cart"));

        foreach (($config ?: []) as $attribute) {
            if(!is_array($attribute) ||
                !array_key_exists("attribute_code", $attribute)) {
                continue;
            }

            $code = $attribute["attribute_code"];

            // Magento looks in the list of keys on the Varien_Object
            $attributes->setData($code, "");
        }
    }
}