<?php

/**
 * Base controller for payment-controllers.
 */
class Crossroads_API_Controller_Payment extends Crossroads_API_Controller_Super {
    const CONFIG_PAYMENT_CALLBACK_SUCCESS = "API_section/payment_callbacks/payment_callback_success_redirect";
    const CONFIG_PAYMENT_CALLBACK_CANCEL  = "API_section/payment_callbacks/payment_callback_cancel_redirect";

    /**
     * Redirects the browser to the order success page.
     *
     * @param  Mage_Core_Model_Store
     * @param  string
     */
    protected function _redirectPaymentSuccess(Mage_Core_Model_Store $store, $orderId) {
        $this->getResponse()->setRedirect(Mage::getUrl("", [
            "_direct"      => Mage::getStoreConfig(self::CONFIG_PAYMENT_CALLBACK_SUCCESS, $store->getId()),
            "_use_rewrite" => false,
            "_query"       => ["orderId" => $orderId]
        ]));
    }

    /**
     * Redirects the browser to the order cancelled page.
     *
     * @param  Mage_Core_Model_Store
     * @param  string
     */
    protected function _redirectPaymentCancel(Mage_Core_Model_Store $store, $orderId) {
        $this->getResponse()->setRedirect(Mage::getUrl("", [
            "_direct"      => Mage::getStoreConfig(self::CONFIG_PAYMENT_CALLBACK_CANCEL, $store->getId()),
            "_use_rewrite" => false,
            "_query"       => ["orderId" => $orderId]
        ]));
    }
}
