<?php

class Crossroads_API_StaticblocksController extends Crossroads_API_Controller_Resource {
    public function getAll() {
        return [404];
    }

    /**
     * @api {get} /staticblocks/:id  Get static block
     * @apiName getStaticBlock
     * @apiGroup Static Blocks
     *
     * @apiParam {String} id  Block identifier
     *
     * @apiSuccess {String}  id        Block identifier
     * @apiSuccess {String}  title
     * @apiSuccess {Integer} blockId
     * @apiSuccess {String}  content   HTML content
     * @apiSuccess {String}  createdAt ISO 8601 timestamp, UTC
     * @apiSuccess {String}  updatedAt ISO 8601 timestamp, UTC
     *
     * @apiSuccessExample {json} Example
     * {"id":"footer_links","title":"Footer Links","blockId":1,"content":"\n<ul>\n    <li><a href=\"http:\/\/example.com\/about-magento-demo-store\">About Us<\/a><\/li>\n    <li><a href=\"http:\/\/example.com\/customer-service\">Customer Service<\/a><\/li>\n<li class=\"last privacy\"><a href=\"http:\/\/example.com\/privacy-policy-cookie-restriction-mode\">Privacy Policy<\/a><\/li>\r\n<\/ul>","createdAt":"2017-03-16T09:02:00Z","updatedAt":"2017-03-16T09:02:01Z"}
     */
    public function getItem($id) {
        $block = Mage::getModel("cms/block")
            ->setStoreId(Mage::app()->getStore()->getId())
            ->load($id);

        if( ! $block || ! $block->getBlockId() || ! $block->getIsActive()) {
            return [404];
        }

        return [200, $this->prepareBlock($block)];
    }

    protected function prepareBlock($block) {
        $processor = Mage::helper("cms")->getPageTemplateProcessor();
        $html      = $processor->filter($block->getContent());

        return [
            "id"        => $block->getIdentifier(),
            "title"     => $block->getTitle(),
            // We do not use this as the id since we can have multiple blocks mapping to the same identifier
            // More useful for debugging
            "blockId"   => (int)$block->getBlockId(),
            "content"   => $html,
            "createdAt" => gmdate("Y-m-d\TH:i:s\Z", strtotime($block->getCreationTime())),
            "updatedAt" => gmdate("Y-m-d\TH:i:s\Z", strtotime($block->getUpdateTime())),
        ];
    }
}
