<?php

class Crossroads_API_ProductsController extends Crossroads_API_Controller_Resource
{
    public function getAll() {
        return [404];
    }

    /**
     * @api {get} /products/:id Get single product
     * @apiName getProduct
     * @apiGroup Product
     *
     * @apiParam {Integer} id The id of the product
     *
     * @apiSuccess {Integer} id                      Product ID
     * @apiSuccess {String}  type                    Product type (simple, configurable etc...)
     * @apiSuccess {String}  name                    Product name
     * @apiSuccess {String}  sku                     Product SKU
     * @apiSuccess {Double}  price                   Product price, includes price rules
     * @apiSuccess {Double}  [specialPrice]          Product special price
     * @apiSuccess {Object[]} [groupPrices]          Group prices, if enabled
     * @apiSuccess {String}   [groupPrices.groupCode]
     * @apiSuccess {Double}   [groupPrices.price]
     * @apiSuccess {Double}  originalPrice           Original product price
     * @apiSuccess {Double}  msrp                    Product list price
     * @apiSuccess {Double}  [discountPercent]
     * @apiSuccess {mixed}   stockQty                Amount in stock, null if information not available
     * @apiSuccess {String}  shortDescription        Short description
     * @apiSuccess {String}  description             Long description
     * @apiSuccess {String}  metaDescription         Meta description
     * @apiSuccess {Object}  attributes              Key value pairs of the selected attributes in API_section/product_view/attributes
     * @apiSuccess {String}  imageLarge              Original product image
     * @apiSuccess {String}  imageMedium             Large product image
     * @apiSuccess {String}  imageSmall              Small product image
     * @apiSuccess {mixed}   [mediaGallery]          Product gallery array, can be null if deactivated or empty if no images are present
     * @apiSuccess {String}  [mediaGallery.thumbnail]  Thumbnail image
     * @apiSuccess {String}  [mediaGallery.largeImage] Large image
     * @apiSuccess {Boolean} isInStock               If product is in stock (this needs to be enabled set in admin settings)
     * @apiSuccess {Boolean} isSalable               If product is salable
     * @apiSuccess {Object[]} [options]                 Null if simple product, array if complex
     * @apiSuccess {Integer} options[].id
     * @apiSuccess {String} options[].title
     * @apiSuccess {Boolean} options[].useAsDefault
     * @apiSuccess {Integer} options[].position
     * @apiSuccess {Object[]} options[].values
     * @apiSuccess {Integer} options[].values[].id
     * @apiSuccess {String} options[].values[].label
     * @apiSuccess {Boolean} options[].values[].isPercent
     * @apiSuccess {Mixed} options[].values[].price    null if not set
     * @apiSuccess {Integer[]} categoryIds   List of category ids this product can be found in
     * @apiSuccess {Object[]} relatedProducts        Related products
     */
    public function getItem($id)
    {
        $product = Mage::getModel('catalog/product')->load($id);

        if( ! $product || !$product->getId() || $product->getStatus() !== Mage_Catalog_Product_Status::STATUS_ENABLED) {
            throw Crossroads_API_ResponseException::create(404, 'Product is missing.', null, 1000);
        }

        return [200, Mage::helper("API/product")->prepareProductDetail($product)];
    }
}
