<?php

class Crossroads_API_CmsController extends Crossroads_API_Controller_Resource
{

    /**
     * @api {get} /cms Fetch a list of all CMS pages
     * @apiName getCmsPages
     * @apiGroup CMS
     *
     * @apiSuccess {Integer} id
     * @apiSuccess {String} title
     * @apiSuccess {String} urlKey
     * @apiSuccess {Integer} sortOrder
     * @apiSuccessExample {json} Example:
     * [ { "id": 3, "title": "Om oss", "urlKey": "om-oss", "sortOrder": 0 }, { "id": 8, "title": "FAQ", "urlKey": "faq", "sortOrder": 0 } ]
     */
    public function getAll()
    {
        $pages = Mage::helper('API/cms')->getAll();

        return [200, $pages];
    }

    /**
     * @api {get} /cms/:id Request CMS page
     * @apiName getCmsPage
     * @apiGroup CMS
     *
     * @apiParam {Integer} id The ID of the cms page
     * @apiSuccess {String} contentHeading Heading for the CMS page
     * @apiSuccess {String} title          Title for the CMS page
     * @apiSuccess {String} urlKey     Identifier for the CMS page
     * @apiSuccess {Boolean} isActive      If the page is active
     * @apiSuccess {mixed}  metaDescription String, null if not set
     * @apiSuccess {mixed}  metaKeywords String, null if not set
     * @apiSuccess {Integer} pageId
     * @apiSuccess {String} rootTemplate
     * @apiSuccess {Integer} sortOrder
     * @apiSuccess {String} createdAt  ISO 8601 UTC
     * @apiSuccess {String} updatedAt  ISO 8601 UTC
     * @apiSuccess {String} html Preformatted HTML
     *
     * @apiSuccessExample {json} Example data:
     * { "contentHeading": "Vanliga Frågor", "title": "FAQ", "urlKey": "faq", "isActive": true, "metaDescription": null, "metaKeywords": null, "pageId": 8, "rootTemplate": "one_column", "sortOrder": 0, "createdAt": "2016-10-26T13:33:17Z", "updatedAt": "2016-11-01T12:16:10Z", "html": "..." }
     */
    public function getItem($id)
    {
        $page = Mage::helper('API/cms')->getItem($id);

        if (empty($page)) {
            return [404];
        }

        return [200, $page];
    }
}
