<?php

class Crossroads_API_Model_System_Config_Source_Customerattrs {
    /**
     * Blacklist of attributes which are used in standard magento.
     */
    protected $ATTRIBUTE_BLACKLIST = [
        "created_at",
        "default_billing",
        "default_shipping",
        "dob",
        "email",
        "firstname",
        "gender",
        "group_id",
        "lastname",
        "middlename",
        "password_hash",
        "prefix",
        "rp_token",
        "rp_token_created_at",
        "store_id",
        "suffix",
        "taxvat",
        "website_id"
    ];

    public function __construct() {
        $blacklist  = $this->ATTRIBUTE_BLACKLIST;
        $attributes = Mage::getResourceModel("customer/attribute_collection")->getItems();

        $this->attributes = array_filter(array_map(function($a) use($blacklist) {
            if(in_array($a->getAttributeCode(), $blacklist)) {
                return false;
            }

            return $a->getData();
        }, $attributes));
    }

    public function toOptionArray() {
        return $this->attributes;
    }
}
