<?php

/**
 * Class Crossroads_API_TestController
 *
 * This is locked to the Crossroads office IP
 */
class Crossroads_API_TestController extends Crossroads_API_Controller_Super
{
    const ALLOWED_IP = "5.150.194.196"; // crossroads firewall

    protected function isAllowed($s, $allowed) {
        $ip = !empty($s['HTTP_X_FORWARDED_FOR']) ? $s['HTTP_X_FORWARDED_FOR'] : $s['REMOTE_ADDR'];

        if ($ip === $allowed || Mage::getIsDeveloperMode()) {
            return true;
        }
        return false;
    }

    public function _construct()
    {
        if (!$this->isAllowed($_SERVER, self::ALLOWED_IP)) {
            header("HTTP/1.0 404 Not Found");
            exit();
        }
    }

    /**
     * @api {get} /test/mail Test email template
     * @apiName testEmailTemplate
     * @apiGroup Test
     *
     * @apiParam {String} template The id of the template to test
     * @apiParam {String} order The id of the order (optional)
     * @apiParam {String} variables, separated by commas (optional)
     */
    public function emailAction()
    {
        $template_id = $this->getRequest()->getParam("template");
        $order_id    = $this->getRequest()->getParam("order");
        $variables   = $this->getRequest()->getParam("variables");

        if (empty($template_id)) {
            return $this->sendData([400]);
        }

        $emailTemplate = Mage::getModel('core/email_template')->load($template_id);

        $emailTemplateVars = explode(",", $variables);

        if (!empty($order_id)) {
            $emailTemplateVars['order'] = Mage::getModel('sales/order')->load($order_id);

            $paymentBlock = Mage::helper('payment')->getInfoBlock($emailTemplateVars['order']->getPayment())->setIsSecureMode(true);
            $paymentBlock->getMethod()->setStore(Mage::app()->getStore());

            $emailTemplateVars['payment_html'] = $paymentBlock->toHtml();
        }

        echo $emailTemplate->getProcessedTemplate($emailTemplateVars);
    }
}
